/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.ServerEngine;
import org.dromara.hutool.log.LogUtil;

public class ServerEngineFactory {
    public static ServerEngine getEngine() {
        return Singleton.get(ServerEngine.class.getName(), ServerEngineFactory::createEngine);
    }

    public static ServerEngine createEngine(ServerConfig config) {
        return ServerEngineFactory.createEngine().init(config);
    }

    public static ServerEngine createEngine(String engineName) throws HttpException {
        if (!StrUtil.endWithIgnoreCase(engineName, "Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader<ServerEngine> list = SpiUtil.loadList(ServerEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase(serviceName, engineName)) continue;
            return list.getService(serviceName);
        }
        throw new HttpException("No such engine named: " + engineName);
    }

    public static ServerEngine createEngine() {
        ServerEngine engine = SpiUtil.loadFirstAvailable(ServerEngine.class);
        LogUtil.debug("Use [{}] Http Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }
}

