/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.tomcat;

import javax.net.ssl.SSLContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.AbstractServerEngine;
import org.dromara.hutool.http.server.engine.tomcat.JSSESSLContext;
import org.dromara.hutool.http.server.engine.tomcat.TomcatRequest;
import org.dromara.hutool.http.server.engine.tomcat.TomcatResponse;

public class TomcatEngine
extends AbstractServerEngine {
    private Tomcat tomcat;

    public TomcatEngine() {
        Assert.notNull(Tomcat.class);
        System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
    }

    @Override
    public void start() {
        this.initEngine();
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new HttpException(e);
        }
    }

    public Tomcat getRawEngine() {
        return this.tomcat;
    }

    @Override
    protected void reset() {
        if (null != this.tomcat) {
            try {
                this.tomcat.destroy();
            }
            catch (LifecycleException e) {
                throw new HttpException(e);
            }
            this.tomcat = null;
        }
    }

    @Override
    protected void initEngine() {
        if (null != this.tomcat) {
            return;
        }
        Tomcat tomcat = new Tomcat();
        tomcat.setHostname(this.config.getHost());
        tomcat.setBaseDir(this.config.getRoot());
        tomcat.setConnector(this.createConnector());
        this.initContext(tomcat);
        this.tomcat = tomcat;
    }

    private Connector createConnector() {
        SSLContext sslContext;
        int maxThreads;
        ServerConfig config = this.config;
        Http11NioProtocol protocol = new Http11NioProtocol();
        int maxHeaderSize = config.getMaxHeaderSize();
        if (maxHeaderSize > 0) {
            protocol.setMaxHttpHeaderSize(maxHeaderSize);
        }
        if ((maxThreads = config.getMaxThreads()) > 0) {
            protocol.setMaxThreads(maxThreads);
        }
        Connector connector = new Connector((ProtocolHandler)protocol);
        connector.setPort(config.getPort());
        int maxBodySize = (int)config.getMaxBodySize();
        if (maxBodySize > 0) {
            connector.setMaxPostSize(maxBodySize);
        }
        if (null != (sslContext = config.getSslContext())) {
            protocol.setSSLEnabled(true);
            protocol.setSecure(true);
            protocol.addSslHostConfig(TomcatEngine.createSSLHostConfig(sslContext));
            connector.setScheme("https");
            connector.setPort(config.getPort());
        }
        return connector;
    }

    private static SSLHostConfig createSSLHostConfig(SSLContext sslContext) {
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        SSLHostConfigCertificate sslHostConfigCertificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.RSA);
        sslHostConfigCertificate.setSslContext((org.apache.tomcat.util.net.SSLContext)new JSSESSLContext(sslContext));
        sslHostConfig.addCertificate(sslHostConfigCertificate);
        return sslHostConfig;
    }

    private void initContext(Tomcat tomcat) {
        Context context = tomcat.addContext("", null);
        context.getPipeline().addValve((Valve)new ValveBase(){

            public void invoke(Request request, Response response) {
                TomcatEngine.this.handler.handle(new TomcatRequest(request), new TomcatResponse(response));
            }
        });
    }
}

