/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;

public class HutoolJSONSerializer
extends StdSerializer<JSON> {
    private static final long serialVersionUID = 1L;

    protected HutoolJSONSerializer() {
        super(JSON.class);
    }

    public void serialize(JSON json, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (json instanceof JSONPrimitive) {
            jsonGenerator.writeObject(((JSONPrimitive)json).getValue());
        } else if (json instanceof JSONObject) {
            jsonGenerator.writeStartObject();
            json.asJSONObject().forEach((k, v) -> {
                try {
                    jsonGenerator.writeObjectField(k, v);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            });
            jsonGenerator.writeEndObject();
        } else if (json instanceof JSONArray) {
            jsonGenerator.writeStartArray();
            json.asJSONArray().forEach(v -> {
                try {
                    jsonGenerator.writeObject(v);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            });
            jsonGenerator.writeEndArray();
        }
    }
}

