/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.reader;

import java.util.function.Predicate;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.lang.wrapper.Wrapper;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.reader.JSONTokener;
import org.dromara.hutool.json.support.InternalJSONUtil;

public class JSONParser {
    private final JSONTokener tokener;
    private final JSONFactory factory;

    public static JSONParser of(JSONTokener tokener, JSONFactory factory) {
        return new JSONParser(tokener, factory);
    }

    public JSONParser(JSONTokener tokener, JSONFactory factory) {
        this.tokener = tokener;
        this.factory = factory;
    }

    public JSONTokener getTokener() {
        return this.tokener;
    }

    public JSON parse() {
        JSON json = this.nextJSON(this.tokener.nextClean());
        this.tokener.checkEnd();
        return json;
    }

    public void parseTo(JSON json) {
        if (null == json) {
            return;
        }
        switch (this.tokener.nextClean()) {
            case '{': {
                this.nextTo((JSONObject)json);
                break;
            }
            case '[': {
                this.nextTo((JSONArray)json);
                break;
            }
            default: {
                throw new JSONException("Unsupported: " + json.getClass());
            }
        }
    }

    private JSON nextJSON(char firstChar) {
        Wrapper<Object> result;
        switch (firstChar) {
            case '{': {
                JSONObject jsonObject = this.factory.ofObj();
                this.nextTo(jsonObject);
                result = jsonObject;
                break;
            }
            case '[': {
                JSONArray jsonArray = this.factory.ofArray();
                this.nextTo(jsonArray);
                result = jsonArray;
                break;
            }
            default: {
                result = this.nextJSONPrimitive(firstChar);
            }
        }
        return result;
    }

    private void nextTo(JSONObject jsonObject) {
        JSONTokener tokener = this.tokener;
        block4: while (true) {
            char c;
            if ((c = tokener.nextClean()) == '}') {
                return;
            }
            String key = tokener.nextKey(c);
            tokener.nextColon();
            this.set(jsonObject, key, this.nextJSON(tokener.nextClean()));
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block4;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    private void set(JSONObject jsonObject, String key, JSON value) {
        Predicate<MutableEntry<Object, Object>> predicate = this.factory.getPredicate();
        if (null != predicate) {
            MutableEntry<String, JSON> entry = new MutableEntry<String, JSON>(key, value);
            if (predicate.test(entry)) {
                jsonObject.putValue(entry.getKey(), entry.getValue());
            }
        } else {
            jsonObject.put(key, value);
        }
    }

    private void nextTo(JSONArray jsonArray) {
        JSONTokener tokener = this.tokener;
        char c;
        while ((c = tokener.nextClean()) != ']') {
            this.set(jsonArray, this.nextJSON(',' == c ? tokener.nextClean() : c));
        }
        return;
    }

    private void set(JSONArray jsonArray, JSON value) {
        Predicate<MutableEntry<Object, Object>> predicate = this.factory.getPredicate();
        if (null != predicate) {
            MutableEntry<Integer, JSON> entry = MutableEntry.of(jsonArray.size(), value);
            if (predicate.test(entry)) {
                jsonArray.setValue(entry.getKey(), entry.getValue());
            }
        } else {
            jsonArray.add(value);
        }
    }

    private JSONPrimitive nextJSONPrimitive(char firstChar) {
        switch (firstChar) {
            case '\"': 
            case '\'': {
                return this.factory.ofPrimitive(this.tokener.nextWrapString(firstChar));
            }
            case 'T': 
            case 't': {
                this.checkTrue(this.tokener.next(3));
                return this.factory.ofPrimitive(true);
            }
            case 'F': 
            case 'f': {
                this.checkFalse(this.tokener.next(4));
                return this.factory.ofPrimitive(false);
            }
            case 'N': 
            case 'n': {
                this.checkNull(this.tokener.next(3));
                return null;
            }
        }
        Object value = InternalJSONUtil.parseNumberOrString(this.tokener.nextUnwrapString(firstChar));
        return null == value ? null : this.factory.ofPrimitive(value);
    }

    private void checkTrue(char[] next) {
        if (!(next[0] != 'r' && next[0] != 'R' || next[1] != 'u' && next[1] != 'U' || next[2] != 'e' && next[2] != 'E')) {
            return;
        }
        throw this.tokener.syntaxError("Expected true but : t" + String.valueOf(next));
    }

    private void checkFalse(char[] next) {
        if (!(next[0] != 'a' && next[0] != 'A' || next[1] != 'l' && next[1] != 'L' || next[2] != 's' && next[2] != 'S' || next[3] != 'e' && next[3] != 'E')) {
            return;
        }
        throw this.tokener.syntaxError("Expected false but : f" + String.valueOf(next));
    }

    private void checkNull(char[] next) {
        if (!(next[0] != 'u' && next[0] != 'U' || next[1] != 'l' && next[1] != 'L' || next[2] != 'l' && next[2] != 'L')) {
            return;
        }
        throw this.tokener.syntaxError("Expected null but : n" + String.valueOf(next));
    }
}

