/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.writer;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.support.InternalJSONUtil;
import org.dromara.hutool.json.support.JSONFormatStyle;
import org.dromara.hutool.json.writer.NumberWriteMode;

public class JSONWriter
implements Appendable,
Flushable,
Closeable {
    private static final long JS_MAX_NUMBER = 0x20000000000000L;
    private static final Pattern JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private final Appendable appendable;
    private final JSONConfig config;
    private final JSONFormatStyle formatStyle;
    private final Predicate<MutableEntry<Object, Object>> predicate;
    private boolean needSeparator;
    private int level;

    public static JSONWriter of(Appendable appendable, int indentFactor, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return JSONWriter.of(appendable, indentFactor, 0, config, predicate);
    }

    public static JSONWriter of(Appendable appendable, int indentFactor, int level, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return new JSONWriter(appendable, JSONFormatStyle.getStyle(indentFactor), level, config, predicate);
    }

    public JSONWriter(Appendable appendable, JSONFormatStyle formatStyle, int level, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        this.appendable = appendable;
        this.formatStyle = formatStyle;
        this.level = level;
        this.config = ObjUtil.defaultIfNull(config, JSONConfig::of);
        this.predicate = predicate;
    }

    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONWriter beginObj() {
        this.append('{');
        this.needSeparator = false;
        ++this.level;
        return this;
    }

    public JSONWriter endObj() {
        return this.end(false);
    }

    public JSONWriter beginArray() {
        this.append('[');
        this.needSeparator = false;
        ++this.level;
        return this;
    }

    public JSONWriter endArray() {
        return this.end(true);
    }

    public JSONWriter writeField(MutableEntry<Object, Object> pair) {
        if (null != this.predicate && !this.predicate.test(pair)) {
            return this;
        }
        Object key = pair.getKey();
        Object value = pair.getValue();
        if (key instanceof Integer) {
            if (null == value && this.config.isIgnoreNullElement()) {
                return this;
            }
            return this.writeValueDirect(value, true);
        }
        if (null == value && this.config.isIgnoreNullValue()) {
            return this;
        }
        this.writeKey(StrUtil.toString(key));
        return this.writeValueDirect(value, false);
    }

    public JSONWriter writeKey(String key) {
        if (this.needSeparator) {
            this.append(',');
        }
        this.writeNewLine().writeIndent(this.level);
        this.writeQuoteStrValue(key);
        return this;
    }

    @Override
    public void flush() {
        if (this.appendable instanceof Flushable) {
            try {
                ((Flushable)((Object)this.appendable)).flush();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.appendable instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.appendable)).close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void writeQuoteStrValue(String csq) {
        InternalJSONUtil.quote(csq, this.appendable);
    }

    public JSONWriter writeSpaceAfterSeparators() {
        if (this.formatStyle.isSpaceAfterSeparators()) {
            return this.append(' ');
        }
        return this;
    }

    public void writeIndent(int count) {
        String indentStr = this.formatStyle.getIndent();
        if (StrUtil.isNotEmpty(indentStr)) {
            for (int i = 0; i < count; ++i) {
                this.append(indentStr);
            }
        }
    }

    public JSONWriter writeNewLine() {
        String newline = this.formatStyle.getNewline();
        if (StrUtil.isNotEmpty(newline)) {
            this.append(newline);
        }
        return this;
    }

    public JSONWriter writeRaw(String csq) {
        try {
            this.appendable.append(csq);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public JSONWriter writeNumber(Number number) {
        boolean isStripTrailingZeros = null == this.config || this.config.isStripTrailingZeros();
        String numberStr = NumberUtil.toStr(number, isStripTrailingZeros);
        if (!ReUtil.isMatch(JSON_NUMBER_PATTERN, (CharSequence)numberStr)) {
            throw new JSONException("Invalid RFC8259 JSON format number: " + numberStr);
        }
        NumberWriteMode numberWriteMode = null == this.config ? NumberWriteMode.NORMAL : this.config.getNumberWriteMode();
        switch (numberWriteMode) {
            case JS: {
                if (number.longValue() > 0x20000000000000L) {
                    this.writeQuoteStrValue(numberStr);
                    break;
                }
                return this.writeRaw(numberStr);
            }
            case STRING: {
                this.writeQuoteStrValue(numberStr);
                break;
            }
            default: {
                return this.writeRaw(numberStr);
            }
        }
        return this;
    }

    @Override
    public JSONWriter append(char c) throws IORuntimeException {
        try {
            this.appendable.append(c);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public JSONWriter append(CharSequence csq) throws IORuntimeException {
        try {
            this.appendable.append(csq);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public JSONWriter append(CharSequence csq, int start, int end) throws IORuntimeException {
        try {
            this.appendable.append(csq, start, end);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public String toString() {
        return this.appendable.toString();
    }

    private JSONWriter end(boolean arrayMode) {
        --this.level;
        this.writeNewLine().writeIndent(this.level);
        this.append(arrayMode ? (char)']' : '}');
        this.flush();
        this.needSeparator = true;
        return this;
    }

    private JSONWriter writeValueDirect(Object value, boolean arrayMode) {
        if (arrayMode) {
            if (this.needSeparator) {
                this.append(',');
            }
            this.writeNewLine().writeIndent(this.level);
        } else {
            this.append(':').writeSpaceAfterSeparators();
        }
        this.needSeparator = true;
        return this.writeObjValue(value);
    }

    private JSONWriter writeObjValue(Object value) {
        if (value == null) {
            this.writeRaw("null");
        } else if (value instanceof JSON) {
            ((JSON)value).write(this);
        } else {
            this.writeQuoteStrValue(value.toString());
        }
        return this;
    }
}

