/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.lang.reflect.Field;
import org.dromara.hutool.core.comparator.FuncComparator;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;

public class FieldComparator<T>
extends FuncComparator<T> {
    private static final long serialVersionUID = 9157326766723846313L;

    public FieldComparator(Class<T> beanClass, String fieldName) {
        this(FieldComparator.getNonNullField(beanClass, fieldName));
    }

    public FieldComparator(Field field) {
        this(true, field);
    }

    public FieldComparator(boolean nullGreater, Field field) {
        super(nullGreater, (T bean) -> (Comparable)FieldUtil.getFieldValue(bean, Assert.notNull(field, "Field must be not null!", new Object[0])));
    }

    private static Field getNonNullField(Class<?> beanClass, String fieldName) {
        Field field = FieldUtil.getField(beanClass, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(StrUtil.format("Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
        return field;
    }
}

