/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.lang.reflect.Field;
import org.dromara.hutool.core.comparator.FieldComparator;
import org.dromara.hutool.core.comparator.NullComparator;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.FieldUtil;

public class FieldsComparator<T>
extends NullComparator<T> {
    private static final long serialVersionUID = 8649196282886500803L;

    public FieldsComparator(Class<T> beanClass, String ... fieldNames) {
        this(true, beanClass, fieldNames);
    }

    public FieldsComparator(boolean nullGreater, Class<T> beanClass, String ... fieldNames) {
        super(nullGreater, (a, b) -> {
            for (String fieldName : fieldNames) {
                Field field = FieldUtil.getField(beanClass, fieldName);
                Assert.notNull(field, "Field [{}] not found in Class [{}]", fieldName, beanClass.getName());
                int compare = new FieldComparator<Object>(field).compare(a, b);
                if (0 == compare) continue;
                return compare;
            }
            return 0;
        });
    }
}

