/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;

public class Deflate
implements Closeable {
    private final InputStream source;
    private OutputStream target;
    private final boolean nowrap;

    public static Deflate of(InputStream source, OutputStream target, boolean nowrap) {
        return new Deflate(source, target, nowrap);
    }

    public Deflate(InputStream source, OutputStream target, boolean nowrap) {
        this.source = source;
        this.target = target;
        this.nowrap = nowrap;
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public Deflate deflater(int level) {
        this.target = this.target instanceof DeflaterOutputStream ? (DeflaterOutputStream)this.target : new DeflaterOutputStream(this.target, new Deflater(level, this.nowrap));
        IoUtil.copy(this.source, this.target);
        try {
            ((DeflaterOutputStream)this.target).finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public Deflate inflater() {
        this.target = this.target instanceof InflaterOutputStream ? (InflaterOutputStream)this.target : new InflaterOutputStream(this.target, new Inflater(this.nowrap));
        IoUtil.copy(this.source, this.target);
        try {
            ((InflaterOutputStream)this.target).finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(this.target);
        IoUtil.closeQuietly(this.source);
    }
}

