/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.FileWrapper;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader of(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader of(File file) {
        return new FileReader(file, DEFAULT_CHARSET);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public byte[] readBytes() throws IORuntimeException {
        try {
            return Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        return this.readLines(collection, null);
    }

    public <T extends Collection<String>> T readLines(T collection, Predicate<String> predicate) throws IORuntimeException {
        this.readLines(s -> {
            if (null == predicate || predicate.test((String)s)) {
                collection.add(s);
            }
        });
        return collection;
    }

    public void readLines(SerConsumer<String> lineHandler) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)reader, lineHandler);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(SerFunction<BufferedReader, T> readerHandler) throws IORuntimeException {
        T result;
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            result = readerHandler.applying(reader);
        }
        catch (Exception e) {
            try {
                if (e instanceof IOException) {
                    throw new IORuntimeException(e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new HutoolException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(reader);
        return result;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoUtil.toReader(this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public long writeToStream(OutputStream out) throws IORuntimeException {
        return this.writeToStream(out, false);
    }

    /*
     * Exception decompiling
     */
    public long writeToStream(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }
}

