/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.ansi;

import org.dromara.hutool.core.lang.ansi.Ansi4BitColor;
import org.dromara.hutool.core.lang.ansi.AnsiElement;
import org.dromara.hutool.core.text.StrUtil;

public enum Ansi4BitBackgroundColor implements AnsiElement
{
    DEFAULT(49),
    BLACK(40),
    RED(41),
    GREEN(42),
    YELLOW(43),
    BLUE(44),
    MAGENTA(45),
    CYAN(46),
    WHITE(47),
    BRIGHT_BLACK(100),
    BRIGHT_RED(101),
    BRIGHT_GREEN(102),
    BRIGHT_YELLOW(103),
    BRIGHT_BLUE(104),
    BRIGHT_MAGENTA(105),
    BRIGHT_CYAN(106),
    BRIGHT_WHITE(107);

    private final int code;

    private Ansi4BitBackgroundColor(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public int getCode(boolean isBackground) {
        return isBackground ? this.code : this.code - 10;
    }

    public Ansi4BitColor asForeground() {
        return Ansi4BitColor.of(this.getCode(false));
    }

    @Override
    public String toString() {
        return StrUtil.toString(this.code);
    }

    public static Ansi4BitBackgroundColor of(int code) {
        for (Ansi4BitBackgroundColor item : Ansi4BitBackgroundColor.values()) {
            if (item.getCode() != code) continue;
            return item;
        }
        throw new IllegalArgumentException(StrUtil.format("No matched Ansi4BitBackgroundColor instance,code={}", code));
    }
}

