/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.MethodUtil;
import org.dromara.hutool.core.reflect.lookup.LookupUtil;

public class MethodHandleUtil {
    public static <T> T invokeHandle(MethodHandle methodHandle, Object ... args) {
        try {
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws HutoolException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        return MethodHandleUtil.invokeExact(obj, method, MethodUtil.actualArgs(method, args));
    }

    public static <T> T invokeExact(Object obj, Method method, Object ... args) throws HutoolException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        try {
            MethodHandle handle = LookupUtil.unreflectMethod(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HutoolException(e);
        }
    }
}

