/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.caller.CallerUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.lookup.ConstructorLookupFactory;
import org.dromara.hutool.core.reflect.lookup.LookupFactory;
import org.dromara.hutool.core.reflect.lookup.MethodLookupFactory;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.JdkUtil;

public class LookupUtil {
    private static final LookupFactory factory = JdkUtil.IS_JDK8 ? new ConstructorLookupFactory() : new MethodLookupFactory();

    public static MethodHandles.Lookup lookup() {
        return LookupUtil.lookup(CallerUtil.getCaller());
    }

    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return factory.lookup(callerClass);
    }

    public static MethodHandle unreflect(Member methodOrConstructor) throws HutoolException {
        try {
            if (methodOrConstructor instanceof Method) {
                return LookupUtil.unreflectMethod((Method)methodOrConstructor);
            }
            return LookupUtil.lookup().unreflectConstructor((Constructor)methodOrConstructor);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e);
        }
    }

    public static MethodHandle unreflectMethod(Method method) throws IllegalAccessException {
        Class<?> caller = method.getDeclaringClass();
        MethodHandles.Lookup lookup = LookupUtil.lookup(caller);
        if (ModifierUtil.isDefault(method)) {
            return lookup.unreflectSpecial(method, caller);
        }
        try {
            return lookup.unreflect(method);
        }
        catch (Exception ignore) {
            return lookup.unreflectSpecial(method, caller);
        }
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, Class<?> returnType, Class<?> ... argTypes) {
        return LookupUtil.findMethod(callerClass, name, MethodType.methodType(returnType, argTypes));
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, MethodType type) {
        if (StrUtil.isBlank(name)) {
            return LookupUtil.findConstructor(callerClass, type);
        }
        MethodHandle handle = null;
        MethodHandles.Lookup lookup = LookupUtil.lookup(callerClass);
        try {
            handle = lookup.findVirtual(callerClass, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (null == handle) {
            try {
                handle = lookup.findStatic(callerClass, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (null == handle) {
            try {
                handle = lookup.findSpecial(callerClass, name, type, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new HutoolException(e);
            }
        }
        return handle;
    }

    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... argTypes) {
        Constructor<?> constructor = ConstructorUtil.getConstructor(callerClass, argTypes);
        if (null != constructor) {
            return LookupUtil.unreflect(constructor);
        }
        return null;
    }

    public static MethodHandle findConstructorExact(Class<?> callerClass, Class<?> ... argTypes) {
        return LookupUtil.findConstructor(callerClass, MethodType.methodType(Void.TYPE, argTypes));
    }

    public static MethodHandle findConstructor(Class<?> callerClass, MethodType type) {
        MethodHandles.Lookup lookup = LookupUtil.lookup(callerClass);
        try {
            return lookup.findConstructor(callerClass, type);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e);
        }
    }
}

