/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.tree.hierarchy;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.dromara.hutool.core.tree.hierarchy.HierarchyIterator;

public class HierarchyIteratorImpl<H, R>
implements HierarchyIterator<H, R> {
    private final Supplier<? extends R> resultFactory;
    private final Predicate<? super H> hierarchyFilter;
    private final BiFunction<? super R, ? super H, ? extends Collection<H>> hierarchyFinder;

    public HierarchyIteratorImpl(Supplier<? extends R> resultFactory, Predicate<? super H> hierarchyFilter, BiFunction<? super R, ? super H, ? extends Collection<H>> hierarchyFinder) {
        this.resultFactory = resultFactory;
        this.hierarchyFilter = hierarchyFilter;
        this.hierarchyFinder = hierarchyFinder;
    }

    @Override
    public Collection<H> nextHierarchies(R result, H hierarchy) {
        return this.hierarchyFinder.apply(result, hierarchy);
    }

    @Override
    public boolean isBreak(H hierarchy) {
        return this.hierarchyFilter.test(hierarchy);
    }

    @Override
    public R getResult() {
        return this.resultFactory.get();
    }
}

