/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.dromara.hutool.core.io.CharsetDetector;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;

public class CharsetUtil {
    public static final String NAME_ISO_8859_1 = "ISO-8859-1";
    public static final String NAME_UTF_8 = "UTF-8";
    public static final String NAME_GBK = "GBK";
    public static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final Charset GBK;

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        return StrUtil.isBlank(charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static Charset parse(String charsetName) {
        return CharsetUtil.parse(charsetName, Charset.defaultCharset());
    }

    public static Charset parse(String charsetName, Charset defaultCharset) {
        Charset result;
        if (StrUtil.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }

    public static String convert(String source, String srcCharset, String destCharset) {
        return CharsetUtil.convert(source, Charset.forName(srcCharset), Charset.forName(destCharset));
    }

    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = UTF_8;
        }
        if (StrUtil.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static File convert(File file, Charset srcCharset, Charset destCharset) {
        String str = FileUtil.readString(file, srcCharset);
        return FileUtil.writeString(str, file, destCharset);
    }

    public static String systemCharsetName() {
        return CharsetUtil.systemCharset().name();
    }

    public static Charset systemCharset() {
        return FileUtil.isWindows() ? GBK : CharsetUtil.defaultCharset();
    }

    public static String defaultCharsetName() {
        return CharsetUtil.defaultCharset().name();
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static Charset detect(InputStream in, Charset ... charsets) {
        return CharsetDetector.detect(in, charsets);
    }

    public static Charset detect(int bufferSize, InputStream in, Charset ... charsets) {
        return CharsetDetector.detect(bufferSize, in, charsets);
    }

    static {
        Charset _GBK = null;
        try {
            _GBK = Charset.forName(NAME_GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        GBK = _GBK;
    }
}

