/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.provider.GlobalProviderFactory;

public class KeyStoreUtil {
    public static final String TYPE_JKS = "JKS";
    public static final String TYPE_JCEKS = "jceks";
    public static final String TYPE_PKCS12 = "pkcs12";

    public static KeyStore readJKSKeyStore(File keyFile, char[] password) {
        return KeyStoreUtil.readKeyStore(TYPE_JKS, keyFile, password);
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return KeyStoreUtil.readKeyStore(TYPE_JKS, in, password);
    }

    public static KeyStore readPKCS12KeyStore(File keyFile, char[] password) {
        return KeyStoreUtil.readKeyStore(TYPE_PKCS12, keyFile, password);
    }

    public static KeyStore readPKCS12KeyStore(InputStream in, char[] password) {
        return KeyStoreUtil.readKeyStore(TYPE_PKCS12, in, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(String type, File keyFile, char[] password) {
        KeyStore keyStore;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(keyFile);
            keyStore = KeyStoreUtil.readKeyStore(type, in, password);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return keyStore;
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(type);
        try {
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(String type) {
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            return null == provider ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
    }
}

