/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class DruidDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4680621702534433222L;
    public static final String DS_NAME = "Druid";

    public DruidDSFactory() {
        this(null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        for (String key2 : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemove(key2);
            if (!StrUtil.isNotBlank(connValue)) continue;
            ds.addConnectionProperty(key2, connValue);
        }
        Props druidProps = new Props();
        poolSetting.forEach((key, value) -> druidProps.put(StrUtil.addPrefixIfNot(key, "druid."), value));
        ds.configFromPropeties((Properties)druidProps);
        String connectionErrorRetryAttemptsKey = "druid.connectionErrorRetryAttempts";
        if (druidProps.containsKey("druid.connectionErrorRetryAttempts")) {
            ds.setConnectionErrorRetryAttempts(druidProps.getInt("druid.connectionErrorRetryAttempts").intValue());
        }
        String timeBetweenConnectErrorMillisKey = "druid.timeBetweenConnectErrorMillis";
        if (druidProps.containsKey("druid.timeBetweenConnectErrorMillis")) {
            ds.setTimeBetweenConnectErrorMillis((long)druidProps.getInt("druid.timeBetweenConnectErrorMillis").intValue());
        }
        String breakAfterAcquireFailureKey = "druid.breakAfterAcquireFailure";
        if (druidProps.containsKey("druid.breakAfterAcquireFailure")) {
            ds.setBreakAfterAcquireFailure(druidProps.getBool("druid.breakAfterAcquireFailure").booleanValue());
        }
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

