/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.tomcat;

import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class TomcatDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4925514193275150156L;
    public static final String DS_NAME = "Tomcat-Jdbc-Pool";

    public TomcatDSFactory() {
        this(null);
    }

    public TomcatDSFactory(Setting setting) {
        super(DS_NAME, DataSource.class, setting);
    }

    @Override
    protected javax.sql.DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        PoolProperties poolProps = new PoolProperties();
        poolProps.setUrl(jdbcUrl);
        poolProps.setDriverClassName(driver);
        poolProps.setUsername(user);
        poolProps.setPassword(pass);
        Props connProps = new Props();
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemove(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        poolProps.setDbProperties((Properties)connProps);
        poolSetting.toBean(poolProps);
        return new DataSource((PoolConfiguration)poolProps);
    }
}

