/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.pinyin.engine.jpinyin;

import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.extra.pinyin.PinyinException;
import org.dromara.hutool.extra.pinyin.engine.PinyinEngine;

public class JPinyinEngine
implements PinyinEngine {
    PinyinFormat format;

    public JPinyinEngine() {
        this(null);
    }

    public JPinyinEngine(PinyinFormat format) {
        this.init(format);
    }

    public void init(PinyinFormat format) {
        if (null == format) {
            format = PinyinFormat.WITHOUT_TONE;
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        String[] results = PinyinHelper.convertToPinyinArray((char)c, (PinyinFormat)this.format);
        return ArrayUtil.isEmpty(results) ? String.valueOf(c) : results[0];
    }

    @Override
    public String getPinyin(String str, String separator) {
        try {
            return PinyinHelper.convertToPinyinString((String)str, (String)separator, (PinyinFormat)this.format);
        }
        catch (com.github.stuxuhai.jpinyin.PinyinException e) {
            throw new PinyinException(e);
        }
    }
}

