/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.xml;

import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.xml.JSONXMLUtil;
import org.dromara.hutool.json.xml.XMLTokener;

public class JSONXMLParser {
    public static void parseJSONObject(JSONObject jo, String xmlStr, boolean keepStrings) throws JSONException {
        XMLTokener x = new XMLTokener(xmlStr, jo.config());
        while (x.more() && x.skipPast("<")) {
            JSONXMLParser.parse(x, jo, null, keepStrings);
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name, boolean keepStrings) throws JSONException {
        String string;
        Object token = x.nextToken();
        if (token == JSONXMLUtil.BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token = x.nextToken();
                if ("CDATA".equals(token) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (string2.length() > 0) {
                        context.append("content", string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token == JSONXMLUtil.LT) {
                    ++i;
                    continue;
                }
                if (token != JSONXMLUtil.GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == JSONXMLUtil.QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token == JSONXMLUtil.SLASH) {
            token = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x.nextToken() != JSONXMLUtil.GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonobject = new JSONObject();
        while (true) {
            if (token == null) {
                token = x.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x.nextToken();
            if (token == JSONXMLUtil.EQ) {
                token = x.nextToken();
                if (!(token instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.append(string, keepStrings ? token : InternalJSONUtil.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.append(string, "");
        }
        if (token == JSONXMLUtil.SLASH) {
            if (x.nextToken() != JSONXMLUtil.GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jsonobject.size() > 0) {
                context.append(tagName, jsonobject);
            } else {
                context.append(tagName, "");
            }
            return false;
        }
        if (token == JSONXMLUtil.GT) {
            while (true) {
                if ((token = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.append("content", keepStrings ? token : InternalJSONUtil.stringToValue(string));
                    continue;
                }
                if (token == JSONXMLUtil.LT && JSONXMLParser.parse(x, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.size() == 0) {
                context.append(tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                context.append(tagName, jsonobject.get("content"));
            } else {
                context.append(tagName, jsonobject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }
}

