/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell.values;

import java.time.LocalDateTime;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.dromara.hutool.poi.excel.ExcelDateUtil;
import org.dromara.hutool.poi.excel.cell.CellValue;

public class NumericCellValue
implements CellValue<Object> {
    private final Cell cell;

    public NumericCellValue(Cell cell) {
        this.cell = cell;
    }

    @Override
    public Object getValue() {
        double value = this.cell.getNumericCellValue();
        CellStyle style = this.cell.getCellStyle();
        if (null != style) {
            long longPart;
            if (ExcelDateUtil.isDateFormat(this.cell)) {
                LocalDateTime date = this.cell.getLocalDateTimeCellValue();
                if (1899 == date.getYear()) {
                    return date.toLocalTime();
                }
                return date;
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }
}

