/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.ExcelUtil;
import org.dromara.hutool.poi.excel.RowUtil;
import org.dromara.hutool.poi.excel.cell.CellEditor;
import org.dromara.hutool.poi.excel.reader.SheetReader;

public abstract class AbstractSheetReader<T>
implements SheetReader<T> {
    protected final int startRowIndex;
    protected final int endRowIndex;
    protected boolean ignoreEmptyRow = true;
    protected CellEditor cellEditor;
    private Map<String, String> headerAlias;

    public AbstractSheetReader(int startRowIndex, int endRowIndex) {
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
    }

    public void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public void setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
    }

    public void setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
    }

    public void addHeaderAlias(String header, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        this.headerAlias.put(header, alias);
    }

    protected List<String> aliasHeader(List<Object> headerList) {
        if (CollUtil.isEmpty(headerList)) {
            return new ArrayList<String>(0);
        }
        int size = headerList.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    protected String aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return ExcelUtil.indexToColName(index);
        }
        String header = headerObj.toString();
        if (null != this.headerAlias) {
            return ObjUtil.defaultIfNull(this.headerAlias.get(header), header);
        }
        return header;
    }

    protected List<Object> readRow(Sheet sheet, int rowIndex) {
        return RowUtil.readRow(sheet.getRow(rowIndex), this.cellEditor);
    }
}

