/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.spring.cglib;

import org.dromara.hutool.core.map.WeakConcurrentMap;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public enum BeanCopierCache {
    INSTANCE;

    private final WeakConcurrentMap<String, BeanCopier> cache = new WeakConcurrentMap();

    public BeanCopier get(Class<?> srcClass, Class<?> targetClass, Converter converter) {
        return this.get(srcClass, targetClass, null != converter);
    }

    public BeanCopier get(Class<?> srcClass, Class<?> targetClass, boolean useConverter) {
        String key = this.genKey(srcClass, targetClass, useConverter);
        return (BeanCopier)this.cache.computeIfAbsent((Object)key, k -> BeanCopier.create((Class)srcClass, (Class)targetClass, (boolean)useConverter));
    }

    private String genKey(Class<?> srcClass, Class<?> targetClass, boolean useConverter) {
        StringBuilder key = StrUtil.builder().append(srcClass.getName()).append('#').append(targetClass.getName()).append('#').append(useConverter ? 1 : 0);
        return key.toString();
    }
}

