/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.jte;

import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.WriterOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.extra.template.Template;

public class JteTemplate
implements Template,
Serializable {
    private static final long serialVersionUID = -2739915422007257186L;
    private final TemplateEngine templateEngine;
    private final String template;
    private final Charset charset;

    public JteTemplate(TemplateEngine engine, String template, Charset charset) {
        this.templateEngine = engine;
        this.template = template;
        this.charset = charset;
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        this.templateEngine.render(this.template, bindingMap, (TemplateOutput)new WriterOutput(writer));
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        this.render(bindingMap, (Writer)IoUtil.toWriter((OutputStream)out, (Charset)this.charset));
    }

    public void render(Object model, Writer writer) {
        this.templateEngine.render(this.template, model, (TemplateOutput)new WriterOutput(writer));
    }

    public void render(Object model, OutputStream out) {
        this.render(model, (Writer)IoUtil.toWriter((OutputStream)out, (Charset)this.charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Object model, File file) {
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream((File)file);
            this.render(model, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
    }

    public String render(Object model) {
        StringWriter writer = new StringWriter();
        this.render(model, (Writer)writer);
        return writer.toString();
    }
}

