/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server;

import java.nio.ByteBuffer;
import org.dromara.mica.mqtt.codec.DecoderException;
import org.dromara.mica.mqtt.codec.DecoderResult;
import org.dromara.mica.mqtt.codec.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.MqttConnectReasonCode;
import org.dromara.mica.mqtt.codec.MqttDecoder;
import org.dromara.mica.mqtt.codec.MqttEncoder;
import org.dromara.mica.mqtt.codec.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.MqttIdentifierRejectedException;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttMessageBuilders;
import org.dromara.mica.mqtt.codec.MqttMessageIdVariableHeader;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttSubscribeMessage;
import org.dromara.mica.mqtt.codec.MqttUnacceptableProtocolVersionException;
import org.dromara.mica.mqtt.codec.MqttUnsubscribeMessage;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.MqttServerProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.intf.TioServerHandler;
import org.tio.utils.buffer.ByteBufferAllocator;

public class MqttServerAioHandler
implements TioServerHandler {
    private static final Logger log = LoggerFactory.getLogger(MqttServerAioHandler.class);
    private final MqttDecoder mqttDecoder;
    private final MqttEncoder mqttEncoder;
    private final ByteBufferAllocator allocator;
    private final MqttServerProcessor processor;

    public MqttServerAioHandler(MqttServerCreator serverCreator, MqttServerProcessor processor) {
        this.mqttDecoder = new MqttDecoder(serverCreator.getMaxBytesInMessage(), serverCreator.getMaxClientIdLength());
        this.mqttEncoder = MqttEncoder.INSTANCE;
        this.allocator = serverCreator.getBufferAllocator();
        this.processor = processor;
    }

    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        return this.mqttDecoder.doDecode(context, buffer, readableLength);
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext context) {
        return this.mqttEncoder.doEncode(context, (MqttMessage)packet, this.allocator);
    }

    public void handler(Packet packet, ChannelContext context) {
        MqttMessage mqttMessage = (MqttMessage)packet;
        DecoderResult decoderResult = mqttMessage.decoderResult();
        if (decoderResult.isFailure()) {
            this.processFailure(context, mqttMessage);
            return;
        }
        log.debug("MqttMessage:{}", (Object)mqttMessage);
        MqttFixedHeader fixedHeader = mqttMessage.fixedHeader();
        MqttMessageType messageType = fixedHeader.messageType();
        if (MqttMessageType.CONNECT == messageType) {
            this.processor.processConnect(context, (MqttConnectMessage)mqttMessage);
            return;
        }
        if (!context.isAccepted()) {
            Tio.remove((ChannelContext)context, (String)"Mqtt connected but is not accepted.");
            return;
        }
        switch (messageType) {
            case PUBLISH: {
                this.processor.processPublish(context, (MqttPublishMessage)mqttMessage);
                break;
            }
            case PUBACK: {
                this.processor.processPubAck(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBREC: {
                this.processor.processPubRec(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBREL: {
                this.processor.processPubRel(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBCOMP: {
                this.processor.processPubComp(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case SUBSCRIBE: {
                this.processor.processSubscribe(context, (MqttSubscribeMessage)mqttMessage);
                break;
            }
            case UNSUBSCRIBE: {
                this.processor.processUnSubscribe(context, (MqttUnsubscribeMessage)mqttMessage);
                break;
            }
            case PINGREQ: {
                this.processor.processPingReq(context);
                break;
            }
            case DISCONNECT: {
                this.processor.processDisConnect(context);
                break;
            }
        }
    }

    private void processFailure(ChannelContext context, MqttMessage mqttMessage) {
        Throwable cause = mqttMessage.decoderResult().getCause();
        if (cause instanceof MqttUnacceptableProtocolVersionException) {
            MqttConnAckMessage message = MqttMessageBuilders.connAck().returnCode(MqttConnectReasonCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION).sessionPresent(false).build();
            Tio.send((ChannelContext)context, (Packet)message);
            Tio.remove((ChannelContext)context, (Throwable)cause, (String)"MqttUnacceptableProtocolVersion");
        } else if (cause instanceof MqttIdentifierRejectedException) {
            MqttConnAckMessage message = MqttMessageBuilders.connAck().returnCode(MqttConnectReasonCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED).sessionPresent(false).build();
            Tio.send((ChannelContext)context, (Packet)message);
            Tio.remove((ChannelContext)context, (Throwable)cause, (String)"MqttIdentifierRejected");
        } else if (cause instanceof DecoderException) {
            log.error(cause.getMessage(), cause);
            Tio.remove((ChannelContext)context, (Throwable)cause, (String)"MqttDecoderException");
        } else {
            log.error(cause.getMessage(), cause);
            Tio.remove((ChannelContext)context, (Throwable)cause, (String)"MqttUnknownException");
        }
    }
}

