/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.core.server.MqttMessageInterceptors;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerAioHandler;
import org.dromara.mica.mqtt.core.server.MqttServerAioListener;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerPublishPermission;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerUniqueIdService;
import org.dromara.mica.mqtt.core.server.broker.DefaultMqttBrokerDispatcher;
import org.dromara.mica.mqtt.core.server.dispatcher.AbstractMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.event.IMqttSessionListener;
import org.dromara.mica.mqtt.core.server.http.core.MqttWebServer;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.session.InMemoryMqttSessionManager;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.server.store.InMemoryMqttMessageStore;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerProcessor;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerUniqueIdServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SslConfig;
import org.tio.core.task.HeartbeatMode;
import org.tio.http.common.HttpConfig;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.buffer.ByteBufferAllocator;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.JsonAdapter;
import org.tio.utils.json.JsonUtil;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.TimerTaskService;

public class MqttServerCreator {
    private static final Logger logger = LoggerFactory.getLogger(MqttServerCreator.class);
    private String name = "Mica-Mqtt-Server";
    private String ip;
    private int port = 1883;
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private int readBufferSize = 8192;
    private int maxBytesInMessage = 0xA00000;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private SslConfig sslConfig;
    private IMqttServerAuthHandler authHandler;
    private IMqttServerUniqueIdService uniqueIdService;
    private IMqttServerSubscribeValidator subscribeValidator;
    private IMqttServerPublishPermission publishPermission;
    private IMqttMessageDispatcher messageDispatcher;
    private IMqttMessageStore messageStore;
    private IMqttSessionManager sessionManager;
    private IMqttSessionListener sessionListener;
    private IMqttMessageListener messageListener;
    private IMqttConnectStatusListener connectStatusListener;
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private int webPort = 8083;
    private boolean websocketEnable = true;
    private boolean httpEnable = false;
    private String httpBasicUsername;
    private String httpBasicPassword;
    private String nodeName;
    private boolean useQueueSend = true;
    private boolean useQueueDecode = false;
    private boolean statEnable = true;
    private Consumer<TioServerConfig> tioConfigCustomize;
    private BiConsumer<TioServerConfig, HttpConfig> webConfigCustomize;
    private final MqttMessageInterceptors messageInterceptors = new MqttMessageInterceptors();
    private TimerTaskService taskService;
    private ExecutorService mqttExecutor;
    private JsonAdapter jsonAdapter;
    private boolean proxyProtocolOn = false;

    public String getName() {
        return this.name;
    }

    public MqttServerCreator name(String name) {
        this.name = name;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public MqttServerCreator ip(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MqttServerCreator port(int port) {
        this.port = port;
        return this;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public MqttServerCreator heartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
        return this;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public MqttServerCreator keepaliveBackoff(float keepaliveBackoff) {
        if ((double)keepaliveBackoff <= 0.5) {
            throw new IllegalArgumentException("keepalive backoff must greater than 0.5");
        }
        this.keepaliveBackoff = keepaliveBackoff;
        return this;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public MqttServerCreator readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public MqttServerCreator maxBytesInMessage(int maxBytesInMessage) {
        if (maxBytesInMessage < 1) {
            throw new IllegalArgumentException("maxBytesInMessage must be greater than 0.");
        }
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public MqttServerCreator bufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        return this;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public MqttServerCreator useSsl(InputStream keyStoreInputStream, String keyPasswd) {
        return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd));
    }

    public MqttServerCreator useSsl(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
        return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (ClientAuth)clientAuth));
    }

    public MqttServerCreator useSsl(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
        return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (InputStream)trustStoreInputStream, (String)trustPassword, (ClientAuth)clientAuth));
    }

    public MqttServerCreator useSsl(String keyStoreFile, String keyPasswd) {
        return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd));
    }

    public MqttServerCreator useSsl(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
        return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (ClientAuth)clientAuth));
    }

    public MqttServerCreator useSsl(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
        return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (String)trustStoreFile, (String)trustPassword, (ClientAuth)clientAuth));
    }

    public MqttServerCreator sslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public IMqttServerAuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public MqttServerCreator authHandler(IMqttServerAuthHandler authHandler) {
        this.authHandler = authHandler;
        return this;
    }

    public MqttServerCreator usernamePassword(String username, String password) {
        return this.authHandler(new DefaultMqttServerAuthHandler(username, password));
    }

    public IMqttServerUniqueIdService getUniqueIdService() {
        return this.uniqueIdService;
    }

    public MqttServerCreator uniqueIdService(IMqttServerUniqueIdService uniqueIdService) {
        this.uniqueIdService = uniqueIdService;
        return this;
    }

    public IMqttServerSubscribeValidator getSubscribeValidator() {
        return this.subscribeValidator;
    }

    public MqttServerCreator subscribeValidator(IMqttServerSubscribeValidator subscribeValidator) {
        this.subscribeValidator = subscribeValidator;
        return this;
    }

    public IMqttServerPublishPermission getPublishPermission() {
        return this.publishPermission;
    }

    public MqttServerCreator publishPermission(IMqttServerPublishPermission publishPermission) {
        this.publishPermission = publishPermission;
        return this;
    }

    public IMqttMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public MqttServerCreator messageDispatcher(IMqttMessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        return this;
    }

    public IMqttMessageStore getMessageStore() {
        return this.messageStore;
    }

    public MqttServerCreator messageStore(IMqttMessageStore messageStore) {
        this.messageStore = messageStore;
        return this;
    }

    public IMqttSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public MqttServerCreator sessionManager(IMqttSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public IMqttSessionListener getSessionListener() {
        return this.sessionListener;
    }

    public MqttServerCreator sessionListener(IMqttSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public IMqttMessageListener getMessageListener() {
        return this.messageListener;
    }

    public MqttServerCreator messageListener(IMqttMessageListener messageListener) {
        this.messageListener = messageListener;
        return this;
    }

    public IMqttConnectStatusListener getConnectStatusListener() {
        return this.connectStatusListener;
    }

    public MqttServerCreator connectStatusListener(IMqttConnectStatusListener connectStatusListener) {
        this.connectStatusListener = connectStatusListener;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public MqttServerCreator debug() {
        this.debug = true;
        return this;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public MqttServerCreator maxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public MqttServerCreator webPort(int webPort) {
        this.webPort = webPort;
        return this;
    }

    public boolean isWebsocketEnable() {
        return this.websocketEnable;
    }

    public MqttServerCreator websocketEnable(boolean websocketEnable) {
        this.websocketEnable = websocketEnable;
        return this;
    }

    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    public MqttServerCreator httpEnable(boolean httpEnable) {
        this.httpEnable = httpEnable;
        return this;
    }

    public String getHttpBasicUsername() {
        return this.httpBasicUsername;
    }

    public MqttServerCreator httpBasicAuth(String username, String password) {
        if (StrUtil.isBlank((CharSequence)username) || StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Mqtt http basic auth username or password is blank.");
        }
        this.httpBasicUsername = username;
        this.httpBasicPassword = password;
        return this;
    }

    public String getHttpBasicPassword() {
        return this.httpBasicPassword;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public MqttServerCreator nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public boolean isUseQueueSend() {
        return this.useQueueSend;
    }

    public MqttServerCreator useQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
        return this;
    }

    public boolean isUseQueueDecode() {
        return this.useQueueDecode;
    }

    public MqttServerCreator useQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
        return this;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public MqttServerCreator statEnable() {
        return this.statEnable(true);
    }

    public MqttServerCreator statEnable(boolean enable) {
        this.statEnable = enable;
        return this;
    }

    public MqttServerCreator tioConfigCustomize(Consumer<TioServerConfig> tioConfigCustomize) {
        this.tioConfigCustomize = tioConfigCustomize;
        return this;
    }

    public BiConsumer<TioServerConfig, HttpConfig> getWebConfigCustomize() {
        return this.webConfigCustomize;
    }

    public MqttServerCreator webConfigCustomize(BiConsumer<TioServerConfig, HttpConfig> webConfigCustomize) {
        this.webConfigCustomize = webConfigCustomize;
        return this;
    }

    public MqttMessageInterceptors getMessageInterceptors() {
        return this.messageInterceptors;
    }

    public MqttServerCreator addInterceptor(IMqttMessageInterceptor interceptor) {
        this.messageInterceptors.add(interceptor);
        return this;
    }

    public MqttServerCreator taskService(TimerTaskService taskService) {
        this.taskService = taskService;
        return this;
    }

    public ExecutorService getMqttExecutor() {
        return this.mqttExecutor;
    }

    public MqttServerCreator mqttExecutor(ExecutorService mqttExecutor) {
        this.mqttExecutor = mqttExecutor;
        return this;
    }

    public JsonAdapter getJsonAdapter() {
        return this.jsonAdapter;
    }

    public MqttServerCreator jsonAdapter(JsonAdapter jsonAdapter) {
        this.jsonAdapter = JsonUtil.getJsonAdapter((JsonAdapter)jsonAdapter);
        return this;
    }

    public boolean isProxyProtocolEnabled() {
        return this.proxyProtocolOn;
    }

    public MqttServerCreator proxyProtocolEnable() {
        return this.proxyProtocolEnable(true);
    }

    public MqttServerCreator proxyProtocolEnable(boolean proxyProtocolOn) {
        this.proxyProtocolOn = proxyProtocolOn;
        return this;
    }

    public MqttServer build() {
        if (StrUtil.isBlank((CharSequence)this.nodeName)) {
            this.nodeName = StrUtil.getNanoId();
        }
        if (this.uniqueIdService == null) {
            this.uniqueIdService = new DefaultMqttServerUniqueIdServiceImpl();
        }
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new DefaultMqttBrokerDispatcher();
        }
        if (this.sessionManager == null) {
            this.sessionManager = new InMemoryMqttSessionManager();
        }
        if (this.messageStore == null) {
            this.messageStore = new InMemoryMqttMessageStore();
        }
        if (this.connectStatusListener == null) {
            this.connectStatusListener = new DefaultMqttConnectStatusListener();
        }
        if (this.taskService == null) {
            this.taskService = new DefaultTimerTaskService(200L, 60);
        }
        if (this.mqttExecutor == null) {
            this.mqttExecutor = ThreadUtils.getBizExecutor((int)ThreadUtils.MAX_POOL_SIZE_FOR_TIO);
        }
        DefaultMqttServerProcessor serverProcessor = new DefaultMqttServerProcessor(this, this.taskService, this.mqttExecutor);
        MqttServerAioHandler handler = new MqttServerAioHandler(this, serverProcessor);
        MqttServerAioListener listener = new MqttServerAioListener(this);
        TioServerConfig tioConfig = new TioServerConfig(this.name, (TioServerHandler)handler, (TioServerListener)listener);
        tioConfig.setUseQueueDecode(this.useQueueDecode);
        tioConfig.setUseQueueSend(this.useQueueSend);
        if (this.readBufferSize > 0) {
            tioConfig.setReadBufferSize(this.readBufferSize);
        }
        tioConfig.statOn = this.statEnable;
        tioConfig.enableProxyProtocol(this.proxyProtocolOn);
        if (this.heartbeatTimeout != null) {
            tioConfig.setHeartbeatTimeout(this.heartbeatTimeout.longValue());
        }
        tioConfig.setHeartbeatBackoff(this.keepaliveBackoff);
        tioConfig.setHeartbeatMode(HeartbeatMode.LAST_RESP);
        if (this.sslConfig != null) {
            tioConfig.setSslConfig(this.sslConfig);
        }
        if (this.debug) {
            tioConfig.debug = true;
        }
        if (this.tioConfigCustomize != null) {
            this.tioConfigCustomize.accept(tioConfig);
        }
        TioServer tioServer = new TioServer(tioConfig);
        logger.info("Mica mqtt http api enable:{} websocket enable:{}", (Object)this.httpEnable, (Object)this.websocketEnable);
        MqttWebServer webServer = this.httpEnable || this.websocketEnable ? MqttWebServer.config(this, tioConfig) : null;
        MqttServer mqttServer = new MqttServer(tioServer, webServer, this, this.taskService);
        if (this.messageDispatcher instanceof AbstractMqttMessageDispatcher) {
            ((AbstractMqttMessageDispatcher)this.messageDispatcher).config(mqttServer);
        }
        return mqttServer;
    }

    public MqttServer start() {
        MqttServer mqttServer = this.build();
        mqttServer.start();
        return mqttServer;
    }
}

