/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.dispatcher;

import java.util.Objects;
import org.dromara.mica.mqtt.codec.MqttMessageBuilders;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.enums.MessageType;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.model.Message;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.server.ServerChannelContext;

public abstract class AbstractMqttMessageDispatcher
implements IMqttMessageDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMqttMessageDispatcher.class);
    protected MqttServer mqttServer;
    protected IMqttMessageListener messageListener;
    protected IMqttSessionManager sessionManager;

    public void config(MqttServer mqttServer) {
        this.mqttServer = mqttServer;
        this.messageListener = mqttServer.getServerCreator().getMessageListener();
        this.sessionManager = mqttServer.getServerCreator().getSessionManager();
    }

    public abstract void sendAll(Message var1);

    @Override
    public boolean send(Message message) {
        String clientId;
        ChannelContext context;
        Objects.requireNonNull(this.mqttServer, "MqttServer require not Null.");
        MessageType messageType = message.getMessageType();
        if (MessageType.SUBSCRIBE == messageType) {
            this.sessionManager.addSubscribe(message.getTopic(), message.getFromClientId(), message.getQos());
        } else if (MessageType.UNSUBSCRIBE == messageType) {
            this.sessionManager.removeSubscribe(message.getTopic(), message.getFromClientId());
        } else if (MessageType.UP_STREAM == messageType) {
            this.mqttServer.sendToClient(message.getTopic(), message);
        } else if (MessageType.DOWN_STREAM == messageType) {
            this.mqttServer.sendToClient(message.getTopic(), message);
        } else if (MessageType.HTTP_API == messageType) {
            String topic = message.getTopic();
            MqttQoS mqttQoS = MqttQoS.valueOf((int)message.getQos());
            this.mqttServer.publishAll(topic, message.getPayload(), mqttQoS, message.isRetain());
            try {
                this.onHttpApiMessage(topic, mqttQoS, message);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        } else if (MessageType.DISCONNECT == messageType && (context = this.mqttServer.getChannelContext(clientId = message.getClientId())) != null) {
            Tio.remove((ChannelContext)context, (String)("Mqtt server delete clients:" + clientId));
        }
        this.sendAll(message);
        return true;
    }

    private void onHttpApiMessage(String topic, MqttQoS mqttQoS, Message message) {
        String clientId = message.getClientId();
        ServerChannelContext context = new ServerChannelContext((TioConfig)this.mqttServer.getServerConfig());
        Node serverNode = this.mqttServer.getTioServer().getServerNode();
        context.setServerNode(serverNode);
        Node clientNode = this.mqttServer.getWebServer().getTioServer().getServerNode();
        context.setClientNode(clientNode);
        context.setBsId(clientId);
        context.setUserId(MessageType.HTTP_API.name());
        MqttPublishMessage publishMessage = MqttMessageBuilders.publish().topicName(topic).qos(mqttQoS).retained(message.isRetain()).payload(message.getPayload()).build();
        this.messageListener.onMessage((ChannelContext)context, clientId, topic, mqttQoS, publishMessage, message);
    }
}

