/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.api;

import java.util.List;
import java.util.function.Function;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.enums.MessageType;
import org.dromara.mica.mqtt.core.server.http.api.code.ResultCode;
import org.dromara.mica.mqtt.core.server.http.api.form.BaseForm;
import org.dromara.mica.mqtt.core.server.http.api.form.PublishForm;
import org.dromara.mica.mqtt.core.server.http.api.form.SubscribeForm;
import org.dromara.mica.mqtt.core.server.http.api.result.Result;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRoutes;
import org.dromara.mica.mqtt.core.server.model.ClientInfo;
import org.dromara.mica.mqtt.core.server.model.Message;
import org.dromara.mica.mqtt.core.server.model.Subscribe;
import org.dromara.mica.mqtt.core.util.PayloadEncode;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.Method;
import org.tio.server.TioServerConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.JsonUtil;

public class MqttHttpApi {
    private final MqttServerCreator serverCreator;
    private final TioServerConfig mqttServerConfig;

    public MqttHttpApi(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig) {
        this.serverCreator = serverCreator;
        this.mqttServerConfig = mqttServerConfig;
    }

    public HttpResponse endpoints(HttpRequest request) {
        return Result.ok(request, MqttHttpRoutes.getRouts().keySet());
    }

    public HttpResponse stats(HttpRequest request) {
        return Result.ok(request, (Object)this.mqttServerConfig.getStat());
    }

    public HttpResponse publish(HttpRequest request) {
        PublishForm form = MqttHttpApi.readForm(request, requestBody -> (PublishForm)JsonUtil.readValue((String)requestBody, PublishForm.class));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(false, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        this.sendPublish(form);
        return Result.ok();
    }

    public HttpResponse publishBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> JsonUtil.readList((String)requestBody, PublishForm.class));
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (PublishForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(false, form, request);
            if (validResponse == null) continue;
            return validResponse;
        }
        for (PublishForm form : formList) {
            this.sendPublish(form);
        }
        return Result.ok();
    }

    private void sendPublish(PublishForm form) {
        String payload = form.getPayload();
        Message message = new Message();
        message.setMessageType(MessageType.HTTP_API);
        message.setClientId(form.getClientId());
        message.setTopic(form.getTopic());
        message.setQos(form.getQos());
        message.setRetain(form.isRetain());
        if (StrUtil.isNotBlank((CharSequence)payload)) {
            message.setPayload(PayloadEncode.decode((String)payload, (String)form.getEncoding()));
        }
        this.serverCreator.getMessageDispatcher().send(message);
    }

    public HttpResponse subscribe(HttpRequest request) {
        SubscribeForm form = MqttHttpApi.readForm(request, requestBody -> (SubscribeForm)JsonUtil.readValue((String)requestBody, SubscribeForm.class));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        int qos = form.getQos();
        if (qos < 0 || qos > 2) {
            return Result.fail(request, ResultCode.E101);
        }
        this.sendSubOrUnSubscribe(form);
        return Result.ok();
    }

    public HttpResponse subscribeBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> JsonUtil.readList((String)requestBody, SubscribeForm.class));
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (SubscribeForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
            if (validResponse != null) {
                return validResponse;
            }
            int qos = form.getQos();
            if (qos >= 0 && qos <= 2) continue;
            return Result.fail(request, ResultCode.E101);
        }
        for (SubscribeForm form : formList) {
            this.sendSubOrUnSubscribe(form);
        }
        return Result.ok();
    }

    public HttpResponse unsubscribe(HttpRequest request) {
        BaseForm form = MqttHttpApi.readForm(request, requestBody -> (BaseForm)JsonUtil.readValue((String)requestBody, BaseForm.class));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        this.sendSubOrUnSubscribe(form);
        return Result.ok();
    }

    public HttpResponse unsubscribeBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> JsonUtil.readList((String)requestBody, BaseForm.class));
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (BaseForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
            if (validResponse == null) continue;
            return validResponse;
        }
        for (BaseForm form : formList) {
            this.sendSubOrUnSubscribe(form);
        }
        return Result.ok();
    }

    public HttpResponse getClientInfo(HttpRequest request) {
        String clientId = request.getParam("clientId");
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        ChannelContext context = Tio.getByBsId((TioConfig)this.mqttServerConfig, (String)clientId);
        if (context == null) {
            return Result.fail(request, ResultCode.E101);
        }
        ClientInfo clientInfo = ClientInfo.form(this.serverCreator, context);
        return Result.ok(request, (Object)clientInfo);
    }

    public HttpResponse getClients(HttpRequest request) {
        int page = request.getInt("_page", 1);
        int limit = request.getInt("_limit", 10000);
        return Result.ok(request, MqttServer.getClients(this.serverCreator, (TioConfig)this.mqttServerConfig, page, limit));
    }

    public HttpResponse deleteClients(HttpRequest request) {
        String clientId = request.getParam("clientId");
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        Message message = new Message();
        message.setClientId(clientId);
        message.setMessageType(MessageType.DISCONNECT);
        this.serverCreator.getMessageDispatcher().send(message);
        return Result.ok();
    }

    public HttpResponse getClientSubscriptions(HttpRequest request) {
        String clientId = request.getParam("clientId");
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        List<Subscribe> subscribeList = this.serverCreator.getSessionManager().getSubscriptions(clientId);
        return Result.ok(new HttpResponse(request), subscribeList);
    }

    private void sendSubOrUnSubscribe(BaseForm form) {
        Message message = new Message();
        message.setFromClientId(form.getClientId());
        message.setTopic(form.getTopic());
        if (form instanceof SubscribeForm) {
            message.setQos(((SubscribeForm)form).getQos());
            message.setMessageType(MessageType.SUBSCRIBE);
        } else {
            message.setMessageType(MessageType.UNSUBSCRIBE);
        }
        this.serverCreator.getMessageDispatcher().send(message);
    }

    private static <T> T readForm(HttpRequest request, Function<String, T> function) {
        byte[] requestBody = request.getBody();
        if (requestBody == null) {
            return null;
        }
        return function.apply(new String(requestBody, HttpConst.CHARSET));
    }

    private static HttpResponse validForm(boolean isTopicFilter, BaseForm form, HttpRequest request) {
        String clientId = form.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        String topic = form.getTopic();
        if (StrUtil.isBlank((CharSequence)topic)) {
            return Result.fail(request, ResultCode.E101);
        }
        try {
            if (isTopicFilter) {
                TopicUtil.validateTopicFilter((String)topic);
            } else {
                TopicUtil.validateTopicName((String)topic);
            }
        }
        catch (IllegalArgumentException exception) {
            return Result.fail(request, ResultCode.E102);
        }
        return null;
    }

    public void register() {
        MqttHttpRoutes.register(Method.GET, "/api/v1/endpoints", this::endpoints);
        MqttHttpRoutes.register(Method.GET, "/api/v1/stats", this::stats);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/publish", this::publish);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/publish/batch", this::publishBatch);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/subscribe", this::subscribe);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/subscribe/batch", this::subscribeBatch);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/unsubscribe", this::unsubscribe);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/unsubscribe/batch", this::unsubscribeBatch);
        MqttHttpRoutes.register(Method.GET, "/api/v1/clients/info", this::getClientInfo);
        MqttHttpRoutes.register(Method.GET, "/api/v1/clients", this::getClients);
        MqttHttpRoutes.register(Method.POST, "/api/v1/clients/delete", this::deleteClients);
        MqttHttpRoutes.register(Method.GET, "/api/v1/client/subscriptions", this::getClientSubscriptions);
    }
}

