/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.core;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.http.api.MqttHttpApi;
import org.dromara.mica.mqtt.core.server.http.api.auth.BasicAuthFilter;
import org.dromara.mica.mqtt.core.server.http.core.MqttWebServerAioHandler;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRequestHandler;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRoutes;
import org.dromara.mica.mqtt.core.server.http.websocket.MqttWsMsgHandler;
import org.tio.core.intf.TioUuid;
import org.tio.core.uuid.SeqTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.json.JsonAdapter;
import org.tio.utils.json.JsonUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class MqttWebServer {
    private final HttpRequestHandler httpRequestHandler = new MqttHttpRequestHandler();
    private final HttpConfig httpConfig;
    private final TioServerConfig serverTioConfig;
    private final MqttWebServerAioHandler mqttWebServerAioHandler;
    private final TioServer tioServer;

    public MqttWebServer(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig, IWsMsgHandler wsMsgHandler) {
        this(serverCreator, mqttServerConfig.getTioServerListener(), wsMsgHandler, mqttServerConfig.tioExecutor, mqttServerConfig.groupExecutor);
    }

    public MqttWebServer(MqttServerCreator serverCreator, TioServerListener serverAioListener, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ExecutorService groupExecutor) {
        this.httpConfig = new HttpConfig(serverCreator.getWebPort());
        this.httpConfig.setBindIp(serverCreator.getIp());
        this.httpConfig.setName(serverCreator.getName() + "-HTTP/Websocket");
        this.httpConfig.setCheckHost(false);
        this.httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.mqttWebServerAioHandler = new MqttWebServerAioHandler(this.httpConfig, this.httpRequestHandler, wsMsgHandler);
        this.serverTioConfig = new TioServerConfig(this.httpConfig.getName(), (TioServerHandler)this.mqttWebServerAioHandler, serverAioListener, tioExecutor, groupExecutor);
        this.serverTioConfig.setSslConfig(serverCreator.getSslConfig());
        this.serverTioConfig.setHeartbeatTimeout(0L);
        this.serverTioConfig.setReadBufferSize(30720);
        this.serverTioConfig.setTioUuid((TioUuid)new SeqTioUuid());
        this.tioServer = new TioServer(this.serverTioConfig);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public MqttWebServerAioHandler getMqttWebServerAioHandler() {
        return this.mqttWebServerAioHandler;
    }

    public TioServerConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public void start() throws IOException {
        this.tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort());
    }

    public boolean stop() {
        return this.tioServer.stop();
    }

    public static MqttWebServer config(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig) {
        if (serverCreator.isHttpEnable()) {
            serverCreator.jsonAdapter(JsonUtil.getJsonAdapter((JsonAdapter)serverCreator.getJsonAdapter()));
            MqttHttpApi httpApi = new MqttHttpApi(serverCreator, mqttServerConfig);
            httpApi.register();
            String username = serverCreator.getHttpBasicUsername();
            String password = serverCreator.getHttpBasicPassword();
            if (Objects.nonNull(username) && Objects.nonNull(password)) {
                MqttHttpRoutes.addFilter(new BasicAuthFilter(username, password));
            }
        }
        MqttWsMsgHandler mqttWsMsgHandler = new MqttWsMsgHandler(serverCreator, mqttServerConfig.getTioHandler());
        MqttWebServer httpServerStarter = new MqttWebServer(serverCreator, mqttServerConfig, mqttWsMsgHandler);
        TioServerConfig httpTioConfig = httpServerStarter.getServerTioConfig();
        BiConsumer<TioServerConfig, HttpConfig> webConfigCustomize = serverCreator.getWebConfigCustomize();
        if (webConfigCustomize != null) {
            webConfigCustomize.accept(httpTioConfig, httpServerStarter.getHttpConfig());
        }
        httpTioConfig.share(mqttServerConfig);
        return httpServerStarter;
    }
}

