/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dromara.mica.mqtt.core.server.http.handler.HttpFilter;
import org.dromara.mica.mqtt.core.server.http.handler.HttpHandler;
import org.dromara.mica.mqtt.core.server.http.handler.RouteInfo;
import org.tio.http.common.Method;
import org.tio.http.common.RequestLine;

public final class MqttHttpRoutes {
    private static final LinkedList<HttpFilter> FILTERS = new LinkedList();
    private static final Map<RouteInfo, HttpHandler> ROUTS = new HashMap<RouteInfo, HttpHandler>();

    public static void addFirstFilter(HttpFilter filter) {
        FILTERS.addFirst(filter);
    }

    public static void addFilter(HttpFilter filter) {
        FILTERS.add(filter);
    }

    public static void addFilter(int index, HttpFilter filter) {
        FILTERS.add(index, filter);
    }

    public static List<HttpFilter> getFilters() {
        return Collections.unmodifiableList(FILTERS);
    }

    public static void register(Method method, String path, HttpHandler handler) {
        ROUTS.put(new RouteInfo(path, method), handler);
    }

    public static HttpHandler getHandler(RequestLine requestLine) {
        String path = requestLine.getPath();
        Method method = requestLine.getMethod();
        return ROUTS.get(new RouteInfo(path, method));
    }

    public static Map<RouteInfo, HttpHandler> getRouts() {
        return Collections.unmodifiableMap(ROUTS);
    }
}

