/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.myth.motan.interceptor;

import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.RpcContext;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.myth.common.bean.context.MythTransactionContext;
import org.dromara.myth.core.interceptor.MythTransactionInterceptor;
import org.dromara.myth.core.mediator.RpcMediator;
import org.dromara.myth.core.service.MythTransactionAspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MotanMythTransactionInterceptor
implements MythTransactionInterceptor {
    private final MythTransactionAspectService mythTransactionAspectService;

    @Autowired
    public MotanMythTransactionInterceptor(MythTransactionAspectService mythTransactionAspectService) {
        this.mythTransactionAspectService = mythTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        Map attachments;
        MythTransactionContext mythTransactionContext = null;
        Request request = RpcContext.getContext().getRequest();
        if (Objects.nonNull(request) && (attachments = request.getAttachments()) != null && !attachments.isEmpty()) {
            mythTransactionContext = RpcMediator.getInstance().acquire(attachments::get);
        }
        return this.mythTransactionAspectService.invoke(mythTransactionContext, pjp);
    }
}

