/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.myth.spring.boot.starter.parent.configuration;

import org.dromara.myth.common.config.MythConfig;
import org.dromara.myth.core.bootstrap.MythTransactionBootstrap;
import org.dromara.myth.core.service.MythInitService;
import org.dromara.myth.spring.boot.starter.parent.config.MythConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableConfigurationProperties
@ComponentScan(basePackages={"org.dromara.myth"})
public class MythAutoConfiguration {
    private final MythConfigProperties mythConfigProperties;

    @Autowired(required=false)
    public MythAutoConfiguration(MythConfigProperties mythConfigProperties) {
        this.mythConfigProperties = mythConfigProperties;
    }

    @Bean
    public MythTransactionBootstrap tccTransactionBootstrap(MythInitService mythInitService) {
        MythTransactionBootstrap bootstrap = new MythTransactionBootstrap(mythInitService);
        bootstrap.builder(this.builder());
        return bootstrap;
    }

    @Bean
    public MythConfig mythConfig() {
        return this.builder().build();
    }

    private MythConfig.Builder builder() {
        return MythTransactionBootstrap.create().setSerializer(this.mythConfigProperties.getSerializer()).setRepositorySuffix(this.mythConfigProperties.getRepositorySuffix()).setRepositorySupport(this.mythConfigProperties.getRepositorySupport()).setNeedRecover(this.mythConfigProperties.getNeedRecover()).setBufferSize(this.mythConfigProperties.getBufferSize()).setScheduledThreadMax(this.mythConfigProperties.getScheduledThreadMax()).setScheduledDelay(this.mythConfigProperties.getScheduledDelay()).setRetryMax(this.mythConfigProperties.getRetryMax()).setRecoverDelayTime(this.mythConfigProperties.getRecoverDelayTime()).setMythDbConfig(this.mythConfigProperties.getMythDbConfig()).setMythFileConfig(this.mythConfigProperties.getMythFileConfig()).setMythMongoConfig(this.mythConfigProperties.getMythMongoConfig()).setMythRedisConfig(this.mythConfigProperties.getMythRedisConfig()).setMythZookeeperConfig(this.mythConfigProperties.getMythZookeeperConfig());
    }
}

