/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.config;

import org.dromara.raincat.common.config.TxDbConfig;
import org.dromara.raincat.common.config.TxFileConfig;
import org.dromara.raincat.common.config.TxMongoConfig;
import org.dromara.raincat.common.config.TxRedisConfig;
import org.dromara.raincat.common.config.TxZookeeperConfig;

public class TxConfig {
    private String repositorySuffix;
    private String serializer = "kryo";
    private String nettySerializer = "kryo";
    private int delayTime = 30;
    private int nettyThreadMax = Runtime.getRuntime().availableProcessors() << 1;
    private int heartTime = 10;
    private String txManagerUrl;
    private Boolean compensation = true;
    private String compensationCacheType;
    private int compensationRecoverTime = 60;
    private int refreshInterval = 60;
    private int retryMax = 10;
    private int recoverDelayTime = 60;
    private int bufferSize = 4096;
    private int consumerThreads = Runtime.getRuntime().availableProcessors() << 1;
    private TxDbConfig txDbConfig;
    private TxMongoConfig txMongoConfig;
    private TxRedisConfig txRedisConfig;
    private TxFileConfig txFileConfig;
    private TxZookeeperConfig txZookeeperConfig;

    public TxConfig(Builder builder) {
        this.builder(builder);
    }

    public TxConfig() {
    }

    public static Builder create() {
        return new Builder();
    }

    public void builder(Builder builder) {
        this.serializer = builder.serializer;
        this.nettySerializer = builder.nettySerializer;
        this.delayTime = builder.delayTime;
        this.nettyThreadMax = builder.nettyThreadMax;
        this.heartTime = builder.heartTime;
        this.txManagerUrl = builder.txManagerUrl;
        this.repositorySuffix = builder.repositorySuffix;
        this.compensationCacheType = builder.compensationCacheType;
        this.compensation = builder.compensation;
        this.retryMax = builder.retryMax;
        this.recoverDelayTime = builder.recoverDelayTime;
        this.refreshInterval = builder.refreshInterval;
        this.bufferSize = builder.bufferSize;
        this.txDbConfig = builder.txDbConfig;
        this.txMongoConfig = builder.txMongoConfig;
        this.txRedisConfig = builder.txRedisConfig;
        this.txZookeeperConfig = builder.txZookeeperConfig;
        this.txFileConfig = builder.txFileConfig;
    }

    public String getRepositorySuffix() {
        return this.repositorySuffix;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public String getNettySerializer() {
        return this.nettySerializer;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public int getNettyThreadMax() {
        return this.nettyThreadMax;
    }

    public int getHeartTime() {
        return this.heartTime;
    }

    public String getTxManagerUrl() {
        return this.txManagerUrl;
    }

    public Boolean getCompensation() {
        return this.compensation;
    }

    public String getCompensationCacheType() {
        return this.compensationCacheType;
    }

    public int getCompensationRecoverTime() {
        return this.compensationRecoverTime;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public int getRecoverDelayTime() {
        return this.recoverDelayTime;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getConsumerThreads() {
        return this.consumerThreads;
    }

    public TxDbConfig getTxDbConfig() {
        return this.txDbConfig;
    }

    public TxMongoConfig getTxMongoConfig() {
        return this.txMongoConfig;
    }

    public TxRedisConfig getTxRedisConfig() {
        return this.txRedisConfig;
    }

    public TxFileConfig getTxFileConfig() {
        return this.txFileConfig;
    }

    public TxZookeeperConfig getTxZookeeperConfig() {
        return this.txZookeeperConfig;
    }

    public void setRepositorySuffix(String repositorySuffix) {
        this.repositorySuffix = repositorySuffix;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    public void setNettySerializer(String nettySerializer) {
        this.nettySerializer = nettySerializer;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public void setNettyThreadMax(int nettyThreadMax) {
        this.nettyThreadMax = nettyThreadMax;
    }

    public void setHeartTime(int heartTime) {
        this.heartTime = heartTime;
    }

    public void setTxManagerUrl(String txManagerUrl) {
        this.txManagerUrl = txManagerUrl;
    }

    public void setCompensation(Boolean compensation) {
        this.compensation = compensation;
    }

    public void setCompensationCacheType(String compensationCacheType) {
        this.compensationCacheType = compensationCacheType;
    }

    public void setCompensationRecoverTime(int compensationRecoverTime) {
        this.compensationRecoverTime = compensationRecoverTime;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setRetryMax(int retryMax) {
        this.retryMax = retryMax;
    }

    public void setRecoverDelayTime(int recoverDelayTime) {
        this.recoverDelayTime = recoverDelayTime;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConsumerThreads(int consumerThreads) {
        this.consumerThreads = consumerThreads;
    }

    public void setTxDbConfig(TxDbConfig txDbConfig) {
        this.txDbConfig = txDbConfig;
    }

    public void setTxMongoConfig(TxMongoConfig txMongoConfig) {
        this.txMongoConfig = txMongoConfig;
    }

    public void setTxRedisConfig(TxRedisConfig txRedisConfig) {
        this.txRedisConfig = txRedisConfig;
    }

    public void setTxFileConfig(TxFileConfig txFileConfig) {
        this.txFileConfig = txFileConfig;
    }

    public void setTxZookeeperConfig(TxZookeeperConfig txZookeeperConfig) {
        this.txZookeeperConfig = txZookeeperConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxConfig)) {
            return false;
        }
        TxConfig other = (TxConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$repositorySuffix = this.getRepositorySuffix();
        String other$repositorySuffix = other.getRepositorySuffix();
        if (this$repositorySuffix == null ? other$repositorySuffix != null : !this$repositorySuffix.equals(other$repositorySuffix)) {
            return false;
        }
        String this$serializer = this.getSerializer();
        String other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        String this$nettySerializer = this.getNettySerializer();
        String other$nettySerializer = other.getNettySerializer();
        if (this$nettySerializer == null ? other$nettySerializer != null : !this$nettySerializer.equals(other$nettySerializer)) {
            return false;
        }
        if (this.getDelayTime() != other.getDelayTime()) {
            return false;
        }
        if (this.getNettyThreadMax() != other.getNettyThreadMax()) {
            return false;
        }
        if (this.getHeartTime() != other.getHeartTime()) {
            return false;
        }
        String this$txManagerUrl = this.getTxManagerUrl();
        String other$txManagerUrl = other.getTxManagerUrl();
        if (this$txManagerUrl == null ? other$txManagerUrl != null : !this$txManagerUrl.equals(other$txManagerUrl)) {
            return false;
        }
        Boolean this$compensation = this.getCompensation();
        Boolean other$compensation = other.getCompensation();
        if (this$compensation == null ? other$compensation != null : !((Object)this$compensation).equals(other$compensation)) {
            return false;
        }
        String this$compensationCacheType = this.getCompensationCacheType();
        String other$compensationCacheType = other.getCompensationCacheType();
        if (this$compensationCacheType == null ? other$compensationCacheType != null : !this$compensationCacheType.equals(other$compensationCacheType)) {
            return false;
        }
        if (this.getCompensationRecoverTime() != other.getCompensationRecoverTime()) {
            return false;
        }
        if (this.getRefreshInterval() != other.getRefreshInterval()) {
            return false;
        }
        if (this.getRetryMax() != other.getRetryMax()) {
            return false;
        }
        if (this.getRecoverDelayTime() != other.getRecoverDelayTime()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        if (this.getConsumerThreads() != other.getConsumerThreads()) {
            return false;
        }
        TxDbConfig this$txDbConfig = this.getTxDbConfig();
        TxDbConfig other$txDbConfig = other.getTxDbConfig();
        if (this$txDbConfig == null ? other$txDbConfig != null : !((Object)this$txDbConfig).equals(other$txDbConfig)) {
            return false;
        }
        TxMongoConfig this$txMongoConfig = this.getTxMongoConfig();
        TxMongoConfig other$txMongoConfig = other.getTxMongoConfig();
        if (this$txMongoConfig == null ? other$txMongoConfig != null : !((Object)this$txMongoConfig).equals(other$txMongoConfig)) {
            return false;
        }
        TxRedisConfig this$txRedisConfig = this.getTxRedisConfig();
        TxRedisConfig other$txRedisConfig = other.getTxRedisConfig();
        if (this$txRedisConfig == null ? other$txRedisConfig != null : !((Object)this$txRedisConfig).equals(other$txRedisConfig)) {
            return false;
        }
        TxFileConfig this$txFileConfig = this.getTxFileConfig();
        TxFileConfig other$txFileConfig = other.getTxFileConfig();
        if (this$txFileConfig == null ? other$txFileConfig != null : !((Object)this$txFileConfig).equals(other$txFileConfig)) {
            return false;
        }
        TxZookeeperConfig this$txZookeeperConfig = this.getTxZookeeperConfig();
        TxZookeeperConfig other$txZookeeperConfig = other.getTxZookeeperConfig();
        return !(this$txZookeeperConfig == null ? other$txZookeeperConfig != null : !((Object)this$txZookeeperConfig).equals(other$txZookeeperConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repositorySuffix = this.getRepositorySuffix();
        result = result * 59 + ($repositorySuffix == null ? 43 : $repositorySuffix.hashCode());
        String $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        String $nettySerializer = this.getNettySerializer();
        result = result * 59 + ($nettySerializer == null ? 43 : $nettySerializer.hashCode());
        result = result * 59 + this.getDelayTime();
        result = result * 59 + this.getNettyThreadMax();
        result = result * 59 + this.getHeartTime();
        String $txManagerUrl = this.getTxManagerUrl();
        result = result * 59 + ($txManagerUrl == null ? 43 : $txManagerUrl.hashCode());
        Boolean $compensation = this.getCompensation();
        result = result * 59 + ($compensation == null ? 43 : ((Object)$compensation).hashCode());
        String $compensationCacheType = this.getCompensationCacheType();
        result = result * 59 + ($compensationCacheType == null ? 43 : $compensationCacheType.hashCode());
        result = result * 59 + this.getCompensationRecoverTime();
        result = result * 59 + this.getRefreshInterval();
        result = result * 59 + this.getRetryMax();
        result = result * 59 + this.getRecoverDelayTime();
        result = result * 59 + this.getBufferSize();
        result = result * 59 + this.getConsumerThreads();
        TxDbConfig $txDbConfig = this.getTxDbConfig();
        result = result * 59 + ($txDbConfig == null ? 43 : ((Object)$txDbConfig).hashCode());
        TxMongoConfig $txMongoConfig = this.getTxMongoConfig();
        result = result * 59 + ($txMongoConfig == null ? 43 : ((Object)$txMongoConfig).hashCode());
        TxRedisConfig $txRedisConfig = this.getTxRedisConfig();
        result = result * 59 + ($txRedisConfig == null ? 43 : ((Object)$txRedisConfig).hashCode());
        TxFileConfig $txFileConfig = this.getTxFileConfig();
        result = result * 59 + ($txFileConfig == null ? 43 : ((Object)$txFileConfig).hashCode());
        TxZookeeperConfig $txZookeeperConfig = this.getTxZookeeperConfig();
        result = result * 59 + ($txZookeeperConfig == null ? 43 : ((Object)$txZookeeperConfig).hashCode());
        return result;
    }

    public String toString() {
        return "TxConfig(repositorySuffix=" + this.getRepositorySuffix() + ", serializer=" + this.getSerializer() + ", nettySerializer=" + this.getNettySerializer() + ", delayTime=" + this.getDelayTime() + ", nettyThreadMax=" + this.getNettyThreadMax() + ", heartTime=" + this.getHeartTime() + ", txManagerUrl=" + this.getTxManagerUrl() + ", compensation=" + this.getCompensation() + ", compensationCacheType=" + this.getCompensationCacheType() + ", compensationRecoverTime=" + this.getCompensationRecoverTime() + ", refreshInterval=" + this.getRefreshInterval() + ", retryMax=" + this.getRetryMax() + ", recoverDelayTime=" + this.getRecoverDelayTime() + ", bufferSize=" + this.getBufferSize() + ", consumerThreads=" + this.getConsumerThreads() + ", txDbConfig=" + this.getTxDbConfig() + ", txMongoConfig=" + this.getTxMongoConfig() + ", txRedisConfig=" + this.getTxRedisConfig() + ", txFileConfig=" + this.getTxFileConfig() + ", txZookeeperConfig=" + this.getTxZookeeperConfig() + ")";
    }

    public static class Builder {
        private String repositorySuffix;
        private String serializer = "kryo";
        private String nettySerializer;
        private int delayTime = 30;
        private int nettyThreadMax = Runtime.getRuntime().availableProcessors() << 1;
        private int heartTime = 10;
        private String txManagerUrl;
        private String compensationCacheType = "db";
        private Boolean compensation = false;
        private int refreshInterval;
        private int retryMax = 3;
        private int recoverDelayTime = 60;
        private int bufferSize = 1024;
        private TxDbConfig txDbConfig;
        private TxMongoConfig txMongoConfig;
        private TxRedisConfig txRedisConfig;
        private TxZookeeperConfig txZookeeperConfig;
        private TxFileConfig txFileConfig;

        public Builder setRepositorySuffix(String repositorySuffix) {
            this.repositorySuffix = repositorySuffix;
            return this;
        }

        public Builder setSerializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder setNettySerializer(String nettySerializer) {
            this.nettySerializer = nettySerializer;
            return this;
        }

        public Builder setDelayTime(int delayTime) {
            this.delayTime = delayTime;
            return this;
        }

        public Builder setNettyThreadMax(int nettyThreadMax) {
            this.nettyThreadMax = nettyThreadMax;
            return this;
        }

        public Builder setHeartTime(int heartTime) {
            this.heartTime = heartTime;
            return this;
        }

        public Builder setRefreshInterval(int refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public Builder setTxManagerUrl(String txManagerUrl) {
            this.txManagerUrl = txManagerUrl;
            return this;
        }

        public Builder setCompensationCacheType(String compensationCacheType) {
            this.compensationCacheType = compensationCacheType;
            return this;
        }

        public Builder setCompensation(Boolean compensation) {
            this.compensation = compensation;
            return this;
        }

        public Builder setRetryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        public Builder setRecoverDelayTime(int recoverDelayTime) {
            this.recoverDelayTime = recoverDelayTime;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setTxDbConfig(TxDbConfig txDbConfig) {
            this.txDbConfig = txDbConfig;
            return this;
        }

        public Builder setTxMongoConfig(TxMongoConfig txMongoConfig) {
            this.txMongoConfig = txMongoConfig;
            return this;
        }

        public Builder setTxRedisConfig(TxRedisConfig txRedisConfig) {
            this.txRedisConfig = txRedisConfig;
            return this;
        }

        public Builder setTxZookeeperConfig(TxZookeeperConfig txZookeeperConfig) {
            this.txZookeeperConfig = txZookeeperConfig;
            return this;
        }

        public Builder setTxFileConfig(TxFileConfig txFileConfig) {
            this.txFileConfig = txFileConfig;
            return this;
        }

        public TxConfig build() {
            return new TxConfig(this);
        }
    }
}

