/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum TransactionRoleEnum {
    START(0, "\u53d1\u8d77\u8005"),
    ACTOR(1, "\u53c2\u4e0e\u8005"),
    GROUP(2, "\u4e8b\u52a1\u7ec4");

    private int code;
    private String desc;

    private TransactionRoleEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionRoleEnum acquireByCode(int code) {
        Optional<TransactionRoleEnum> roleEnum = Arrays.stream(TransactionRoleEnum.values()).filter(v -> Objects.equals(v.getCode(), code)).findFirst();
        return roleEnum.orElse(START);
    }

    public static String acquireDescByCode(int code) {
        return TransactionRoleEnum.acquireByCode(code).getDesc();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

