/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.holder;

import java.util.Random;

public final class IdWorkerUtils {
    private static final Random RANDOM = new Random();
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATACENTERIDBITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATACENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATACENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final IdWorkerUtils ID_WORKER_UTILS = new IdWorkerUtils();
    private long workerId;
    private long datacenterId;
    private long idepoch;
    private long sequence = 48L;
    private long lastTimestamp = -1L;

    private IdWorkerUtils() {
        this(RANDOM.nextInt(31), RANDOM.nextInt(31), 1288834974657L);
    }

    private IdWorkerUtils(long workerId, long datacenterId, long idepoch) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.idepoch = idepoch;
    }

    public static IdWorkerUtils getInstance() {
        return ID_WORKER_UTILS;
    }

    private synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.idepoch << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public String buildPartNumber() {
        return "P" + ID_WORKER_UTILS.nextId();
    }

    public String createTaskKey() {
        return String.valueOf(ID_WORKER_UTILS.nextId());
    }

    public String createUUID() {
        return String.valueOf(ID_WORKER_UTILS.nextId());
    }

    public String createGroupId() {
        return String.valueOf(ID_WORKER_UTILS.nextId());
    }

    public long randomUUID() {
        return ID_WORKER_UTILS.nextId();
    }
}

