/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.dromara.raincat.common.enums.SerializeProtocolEnum;
import org.dromara.raincat.common.netty.serizlize.hessian.HessianCodecServiceImpl;
import org.dromara.raincat.common.netty.serizlize.hessian.HessianDecoder;
import org.dromara.raincat.common.netty.serizlize.hessian.HessianEncoder;
import org.dromara.raincat.common.netty.serizlize.kryo.KryoCodecServiceImpl;
import org.dromara.raincat.common.netty.serizlize.kryo.KryoDecoder;
import org.dromara.raincat.common.netty.serizlize.kryo.KryoEncoder;
import org.dromara.raincat.common.netty.serizlize.kryo.KryoPoolFactory;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffCodecServiceImpl;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffDecoder;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffEncoder;

public class NettyPipelineInit {
    public static void serializePipeline(SerializeProtocolEnum serializeProtocol, ChannelPipeline pipeline) {
        switch (serializeProtocol) {
            case KRYO: {
                KryoCodecServiceImpl kryoCodecServiceImpl = new KryoCodecServiceImpl(KryoPoolFactory.getKryoPoolInstance());
                pipeline.addLast(new ChannelHandler[]{new KryoEncoder(kryoCodecServiceImpl)});
                pipeline.addLast(new ChannelHandler[]{new KryoDecoder(kryoCodecServiceImpl)});
                break;
            }
            case HESSIAN: {
                HessianCodecServiceImpl hessianCodecServiceImpl = new HessianCodecServiceImpl();
                pipeline.addLast(new ChannelHandler[]{new HessianEncoder(hessianCodecServiceImpl)});
                pipeline.addLast(new ChannelHandler[]{new HessianDecoder(hessianCodecServiceImpl)});
                break;
            }
            case PROTOSTUFF: {
                ProtostuffCodecServiceImpl protostuffCodecServiceImpl = new ProtostuffCodecServiceImpl();
                pipeline.addLast(new ChannelHandler[]{new ProtostuffEncoder(protostuffCodecServiceImpl)});
                pipeline.addLast(new ChannelHandler[]{new ProtostuffDecoder(protostuffCodecServiceImpl)});
                break;
            }
            default: {
                KryoCodecServiceImpl defaultCodec = new KryoCodecServiceImpl(KryoPoolFactory.getKryoPoolInstance());
                pipeline.addLast(new ChannelHandler[]{new KryoEncoder(defaultCodec)});
                pipeline.addLast(new ChannelHandler[]{new KryoDecoder(defaultCodec)});
            }
        }
    }
}

