/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.kryo;

import com.esotericsoftware.kryo.pool.KryoPool;
import com.google.common.io.Closer;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.dromara.raincat.common.netty.MessageCodecService;
import org.dromara.raincat.common.netty.serizlize.kryo.KryoSerialize;

public class KryoCodecServiceImpl
implements MessageCodecService {
    private KryoPool pool;

    public KryoCodecServiceImpl(KryoPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuf out, Object message) throws IOException {
        try (Closer closer = Closer.create();){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            closer.register((Closeable)byteArrayOutputStream);
            KryoSerialize kryoSerialization = new KryoSerialize(this.pool);
            kryoSerialization.serialize(byteArrayOutputStream, message);
            byte[] body = byteArrayOutputStream.toByteArray();
            int dataLength = body.length;
            out.writeInt(dataLength);
            out.writeBytes(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(byte[] body) throws IOException {
        try (Closer closer = Closer.create();){
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
            closer.register((Closeable)byteArrayInputStream);
            KryoSerialize kryoSerialization = new KryoSerialize(this.pool);
            Object object = kryoSerialization.deserialize(byteArrayInputStream);
            return object;
        }
    }
}

