/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.protostuff;

import com.google.common.io.Closer;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.dromara.raincat.common.netty.MessageCodecService;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffSerialize;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffSerializePool;

public class ProtostuffCodecServiceImpl
implements MessageCodecService {
    private static Closer closer = Closer.create();
    private ProtostuffSerializePool pool = ProtostuffSerializePool.getProtostuffPoolInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuf out, Object message) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            closer.register((Closeable)byteArrayOutputStream);
            ProtostuffSerialize protostuffSerialization = this.pool.borrow();
            protostuffSerialization.serialize(byteArrayOutputStream, message);
            byte[] body = byteArrayOutputStream.toByteArray();
            int dataLength = body.length;
            out.writeInt(dataLength);
            out.writeBytes(body);
            this.pool.restore(protostuffSerialization);
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(byte[] body) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
            closer.register((Closeable)byteArrayInputStream);
            ProtostuffSerialize protostuffSerialization = this.pool.borrow();
            Object obj = protostuffSerialization.deserialize(byteArrayInputStream);
            this.pool.restore(protostuffSerialization);
            Object object = obj;
            return object;
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

