/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.protostuff;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.raincat.common.netty.NettyTransferSerialize;
import org.dromara.raincat.common.netty.bean.HeartBeat;
import org.dromara.raincat.common.netty.serizlize.protostuff.SchemaCache;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerialize
implements NettyTransferSerialize {
    private static SchemaCache cachedSchema = SchemaCache.getInstance();
    private static Objenesis objenesis = new ObjenesisStd(true);

    private static <T> Schema<T> getSchema(Class<T> cls) {
        return cachedSchema.get(cls);
    }

    @Override
    public Object deserialize(InputStream input) {
        try {
            HeartBeat message = (HeartBeat)objenesis.newInstance(HeartBeat.class);
            Schema<HeartBeat> schema = ProtostuffSerialize.getSchema(HeartBeat.class);
            ProtostuffIOUtil.mergeFrom((InputStream)input, (Object)message, schema);
            return message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void serialize(OutputStream output, Object object) {
        Class<?> cls = object.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ProtostuffSerialize.getSchema(cls);
            ProtostuffIOUtil.writeTo((OutputStream)output, (Object)object, schema, (LinkedBuffer)buffer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }
}

