/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.FileTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeExpiredPoolCache {
    private static final Logger log = LoggerFactory.getLogger(TimeExpiredPoolCache.class);
    private static final String FILE_TYPE = "persistence.data";
    private static final long defaultCachedMillis = 86400000L;
    private static final long timerMillis = 30000L;
    private static ConcurrentHashMap<String, DataWrapper<?>> dataPool = null;
    private static TimeExpiredPoolCache instance = null;
    private static final Timer timer = new Timer();

    private TimeExpiredPoolCache() {
    }

    private static synchronized void syncInit() {
        if (instance == null) {
            instance = new TimeExpiredPoolCache();
            dataPool = new ConcurrentHashMap();
            TimeExpiredPoolCache.initTimer();
        }
    }

    public static TimeExpiredPoolCache getInstance() {
        if (instance == null) {
            TimeExpiredPoolCache.syncInit();
        }
        return instance;
    }

    private static boolean persistenceInit() {
        String path = FileTool.getPath() + FILE_TYPE;
        try {
            DataWrapper d = (DataWrapper)JSONUtil.toBean((String)FileTool.readFile(path), DataWrapper.class);
            if (dataPool != null) {
                return true;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return false;
    }

    private static void initTimer() {
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    TimeExpiredPoolCache.clearExpiredCaches();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new SmsBlendException(e.getMessage());
                }
            }
        }, 30000L, 30000L);
    }

    private static void persistence() {
        String path = FileTool.getPath() + FILE_TYPE;
        FileTool.createFile(path);
        FileTool.writeFile(new File(path), JSONUtil.toJsonStr(dataPool), false);
    }

    private static void clearExpiredCaches() {
        LinkedList<String> expiredKeyList = new LinkedList<String>();
        for (Map.Entry<String, DataWrapper<?>> entry : dataPool.entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            expiredKeyList.add(entry.getKey());
        }
        for (String key : expiredKeyList) {
            dataPool.remove(key);
        }
    }

    public <T> T put(String key, T data, long cachedMillis, DataRenewer<T> dataRenewer) throws Exception {
        DataWrapper<Object> dataWrapper = dataPool.get(key);
        if (data == null && dataRenewer != null) {
            data = dataRenewer.renewData();
        }
        if (data == null) {
            return null;
        }
        if (dataWrapper != null) {
            dataWrapper.update(data, cachedMillis);
        } else {
            dataWrapper = new DataWrapper(data, cachedMillis);
            dataPool.put(key, dataWrapper);
        }
        return data;
    }

    public <T> T put(String key, T data, long cachedMillis) throws Exception {
        DataWrapper<Object> dataWrapper = dataPool.get(key);
        if (dataWrapper != null) {
            dataWrapper.update(data, cachedMillis);
        } else {
            dataWrapper = new DataWrapper(data, cachedMillis);
            dataPool.put(key, dataWrapper);
        }
        return data;
    }

    @Deprecated
    public <T> T put(String key, T data, DataRenewer<T> dataRenewer) throws Exception {
        return this.put(key, data, 86400000L, dataRenewer);
    }

    public <T> T get(String key, long cachedMillis, DataRenewer<T> dataRenewer) throws Exception {
        DataWrapper<?> dataWrapper = dataPool.get(key);
        if (dataWrapper != null && !dataWrapper.isExpired()) {
            return (T)((DataWrapper)dataWrapper).data;
        }
        return this.put(key, null, cachedMillis, dataRenewer);
    }

    public <T> T get(String key) {
        DataWrapper<?> dataWrapper = dataPool.get(key);
        if (dataWrapper != null && !dataWrapper.isExpired()) {
            return (T)((DataWrapper)dataWrapper).data;
        }
        return null;
    }

    public void clear() {
        dataPool.clear();
    }

    public void remove(String key) {
        dataPool.remove(key);
    }

    private static class DataWrapper<T> {
        private T data;
        private long expiredTime;
        private long cachedMillis;

        private DataWrapper(T data, long cachedMillis) {
            this.update(data, cachedMillis);
        }

        public void update(T data, long cachedMillis) {
            this.data = data;
            this.cachedMillis = cachedMillis;
            this.updateExpiredTime();
        }

        public void updateExpiredTime() {
            this.expiredTime = System.currentTimeMillis() + this.cachedMillis;
        }

        public boolean isExpired() {
            if (this.expiredTime > 0L) {
                return System.currentTimeMillis() > this.expiredTime;
            }
            return true;
        }
    }

    public static interface DataRenewer<T> {
        public T renewData();
    }
}

