/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SmsUtils {
    private SmsUtils() {
    }

    public static String getRandomString(int len) {
        return RandomUtil.randomString((String)(RandomUtil.BASE_CHAR_NUMBER + "abcdefghijklmnopqrstuvwxyz".toUpperCase()), (int)len);
    }

    public static String getRandomString() {
        return SmsUtils.getRandomString(6);
    }

    public static String getRandomInt(int len) {
        return RandomUtil.randomString((String)"0123456789", (int)len);
    }

    public static boolean isEmpty(Object str) {
        return ObjectUtil.isEmpty((Object)str);
    }

    public static boolean isNotEmpty(Object str) {
        return !SmsUtils.isEmpty(str);
    }

    public static <T> T jsonForObject(String json, Class<T> t) {
        return (T)JSONUtil.toBean((String)json, t);
    }

    public static <T, M> void copyBean(T t, M m) {
        BeanUtil.copyProperties(t, m, (String[])new String[0]);
    }

    public static LinkedHashMap<String, String> getNewMap() {
        return new LinkedHashMap<String, String>();
    }

    public static String listToString(List<String> list) {
        return CollUtil.join(list, (CharSequence)",");
    }

    public static String arrayToString(List<String> list) {
        return CollUtil.join(list, (CharSequence)",", str -> StrUtil.addPrefixIfNot((CharSequence)str, (CharSequence)"+86"));
    }

    public static String[] listToArray(List<String> list) {
        ArrayList<String> toStr = new ArrayList<String>();
        for (String s : list) {
            toStr.add(StrUtil.addPrefixIfNot((CharSequence)s, (CharSequence)"+86"));
        }
        return toStr.toArray(new String[list.size()]);
    }

    public static void replaceKeysSeperator(Map<String, Object> map, String seperator, String newSeperator) {
        if (CollUtil.isEmpty(map)) {
            return;
        }
        ArrayList<String> keySet = new ArrayList<String>(map.keySet());
        for (String key : keySet) {
            if (StrUtil.isEmpty((CharSequence)key) || !key.contains(seperator)) continue;
            String value = String.valueOf(map.get(key));
            String newKey = key.replaceAll(seperator, newSeperator);
            map.putIfAbsent(newKey, value);
            map.remove(key);
        }
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

