/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.emay.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.emay.config.EmayConfig;
import org.dromara.sms4j.emay.service.EmaySmsImpl;
import org.dromara.sms4j.provider.base.BaseProviderFactory;

public class EmayFactory
implements BaseProviderFactory<EmaySmsImpl, EmayConfig> {
    private static EmaySmsImpl emaySms;
    private static final EmayFactory INSTANCE;

    private EmayFactory() {
    }

    public static EmayFactory instance() {
        return INSTANCE;
    }

    @Override
    public EmaySmsImpl createSms(EmayConfig emayConfig) {
        if (emaySms == null) {
            emaySms = this.createMultitonSms(emayConfig);
        }
        return emaySms;
    }

    @Override
    public EmaySmsImpl createMultitonSms(EmayConfig emayConfig) {
        return new EmaySmsImpl(emayConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public EmaySmsImpl refresh(EmayConfig emayConfig) {
        emaySms = new EmaySmsImpl(emayConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return emaySms;
    }

    @Override
    public EmayConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(EmayConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new EmayFactory();
    }

    private static final class ConfigHolder {
        private static EmayConfig config = EmayConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

