/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.netease.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.netease.config.NeteaseConfig;
import org.dromara.sms4j.netease.utils.NeteaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeteaseSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(NeteaseSmsImpl.class);
    private NeteaseConfig config;

    public NeteaseSmsImpl(NeteaseConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        Optional.ofNullable(phone).orElseThrow(() -> new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Optional.ofNullable(this.config.getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        return this.getSmsResponse(this.config.getTemplateUrl(), Collections.singletonList(phone), message, this.config.getTemplateId());
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        Optional.ofNullable(phone).orElseThrow(() -> new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Optional.ofNullable(this.config.getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        String messageStr = messages.get("params");
        return this.getSmsResponse(this.config.getTemplateUrl(), Collections.singletonList(phone), messageStr, templateId);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        if (phones.size() < 1) {
            throw new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (phones.size() > 100) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e100");
        }
        Optional.ofNullable(this.config.getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        return this.getSmsResponse(this.config.getTemplateUrl(), phones, this.config.getTemplateId(), message);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 100) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e100");
        }
        Optional.ofNullable(this.config.getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        String messageStr = messages.get("message");
        return this.getSmsResponse(this.config.getTemplateUrl(), phones, messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String requestUrl, List<String> phones, String message, String templateId) {
        AtomicReference reference = new AtomicReference();
        String nonce = IdUtil.fastSimpleUUID();
        String curTime = String.valueOf(DateUtil.currentSeconds());
        String checkSum = NeteaseUtils.getCheckSum(this.config.getAccessKeyId(), nonce, curTime);
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(4);
        body.put("templateid", templateId);
        body.put("mobiles", JSONArray.parseArray((String)JSON.toJSONString(phones)).toJSONString());
        body.put("params", message);
        body.put("needUp", this.config.getNeedUp());
        this.http.post(requestUrl).addHeader("Content-Type", (Object)"application/x-www-form-urlencoded").addHeader("AppKey", (Object)this.config.getAccessKeyId()).addHeader("Nonce", (Object)nonce).addHeader("CurTime", (Object)curTime).addHeader("CheckSum", (Object)checkSum).addBody(body).onSuccess((data, req, res) -> reference.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).onError((ex, req, res) -> reference.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).execute();
        return (SmsResponse)reference.get();
    }

    private SmsResponse getResponse(JSONObject jsonObject) {
        SmsResponse response = new SmsResponse();
        Integer code = jsonObject.getInteger("code");
        if (code > 200) {
            response.setErrorCode(String.valueOf(code));
            response.setErrMessage(jsonObject.getString("msg"));
        } else {
            response.setSuccess(true);
            response.setCode(String.valueOf(code));
            response.setMessage(jsonObject.getString("msg"));
            response.setData(jsonObject.get((Object)"obj"));
        }
        return response;
    }
}

