/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.netease.utils;

import java.security.MessageDigest;
import org.dromara.sms4j.comm.exception.SmsBlendException;

public class NeteaseUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getCheckSum(String appSecret, String nonce, String curTime) {
        return NeteaseUtils.encode("sha1", appSecret + nonce + curTime);
    }

    private static String encode(String algorithm, String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(value.getBytes());
            return NeteaseUtils.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new SmsBlendException(e.getMessage());
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }
}

