/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.huawei.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.huawei.config.HuaweiConfig;
import org.dromara.sms4j.huawei.utils.HuaweiBuilder;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiSmsImpl
extends AbstractSmsBlend<HuaweiConfig> {
    private static final Logger log = LoggerFactory.getLogger(HuaweiSmsImpl.class);
    private int retry = 0;

    public HuaweiSmsImpl(HuaweiConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public HuaweiSmsImpl(HuaweiConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "huawei";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> mes = new LinkedHashMap<String, String>();
        mes.put(UUID.randomUUID().toString().replaceAll("-", ""), message);
        return this.sendMessage(phone, ((HuaweiConfig)this.getConfig()).getTemplateId(), mes);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        String url = ((HuaweiConfig)this.getConfig()).getUrl() + "/sms/batchSendSms/v1";
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String mess = HuaweiBuilder.listToString(list);
        String requestBody = HuaweiBuilder.buildRequestBody(((HuaweiConfig)this.getConfig()).getSender(), phone, templateId, mess, ((HuaweiConfig)this.getConfig()).getStatusCallBack(), ((HuaweiConfig)this.getConfig()).getSignature());
        try {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(3);
            headers.put("Authorization", "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"");
            headers.put("X-WSSE", HuaweiBuilder.buildWsseHeader(((HuaweiConfig)this.getConfig()).getAccessKeyId(), ((HuaweiConfig)this.getConfig()).getAccessKeySecret()));
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            SmsResponse smsResponse = this.getResponse(this.http.postJson(url, headers, requestBody));
            if (smsResponse.isSuccess() || this.retry == ((HuaweiConfig)this.getConfig()).getMaxRetries()) {
                this.retry = 0;
                return smsResponse;
            }
            return this.requestRetry(phone, templateId, messages);
        }
        catch (SmsBlendException e) {
            return this.requestRetry(phone, templateId, messages);
        }
    }

    private SmsResponse requestRetry(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.http.safeSleep(((HuaweiConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.sendMessage(phone, templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.sendMessage(CollUtil.join(phones, (CharSequence)","), message);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        return this.sendMessage(CollUtil.join(phones, (CharSequence)","), templateId, messages);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("000000".equals(resJson.getStr((Object)"code")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

