/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.dingzhong.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsHttpUtils;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.dingzhong.config.DingZhongConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingZhongHelper {
    private static final Logger log = LoggerFactory.getLogger(DingZhongHelper.class);
    private final DingZhongConfig config;
    private final SmsHttpUtils http;
    private int retry = 0;

    public DingZhongHelper(DingZhongConfig config, SmsHttpUtils http) {
        this.config = config;
        this.http = http;
    }

    public SmsResponse smsResponse(Map<String, Object> paramMap) {
        String url = String.format("%s/%s", this.config.getRequestUrl(), SmsUtils.isEmpty((Object)paramMap.get("templateId")) ? this.config.getBaseAction() : this.config.getTemplateAction());
        HashMap headers = MapUtil.newHashMap((int)2, (boolean)true);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        SmsResponse smsResponse = null;
        try {
            smsResponse = this.getResponse(this.http.postFrom(url, (Map)headers, paramMap));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == this.config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(paramMap);
    }

    private SmsResponse requestRetry(Map<String, Object> paramMap) {
        this.http.safeSleep(this.config.getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.smsResponse(paramMap);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("0".equals(resJson.getStr((Object)"resCode")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.config.getConfigId());
        return smsResponse;
    }
}

