/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.unisms.core;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsHttpUtils;
import org.dromara.sms4j.unisms.core.MapKeyComparator;
import org.dromara.sms4j.unisms.core.UniResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniClient {
    private static final Logger log = LoggerFactory.getLogger(UniClient.class);
    public static final String USER_AGENT = "uni-java-sdk/0.0.4";
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String endpoint;
    private final String signingAlgorithm;
    private boolean isSimple;
    private final int retryInterval;
    private final int maxRetries;
    private int retry = 0;
    private final SmsHttpUtils http = SmsHttpUtils.instance();

    protected UniClient(Builder b) {
        this.accessKeyId = b.accessKeyId;
        this.accessKeySecret = b.accessKeySecret;
        this.endpoint = b.endpoint;
        this.signingAlgorithm = b.signingAlgorithm;
        this.retryInterval = b.retryInterval;
        this.maxRetries = b.maxRetries;
    }

    private static String getSignature(String message, String secretKey) {
        try {
            HMac hMac = new HMac(HmacAlgorithm.HmacSHA256, secretKey.getBytes());
            byte[] bytes = hMac.digest(message.getBytes());
            return Base64.encode((byte[])bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String queryStringify(Map<String, Object> params) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(new MapKeyComparator());
        sortedMap.putAll(params);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry stringObjectEntry : sortedMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(stringObjectEntry.getKey()).append("=").append(stringObjectEntry.getValue());
        }
        return sb.toString();
    }

    private Map<String, Object> sign(Map<String, Object> query) {
        if (this.accessKeySecret != null) {
            query.put("algorithm", this.signingAlgorithm);
            query.put("timestamp", new Date().getTime());
            query.put("nonce", UUID.randomUUID().toString().replaceAll("-", ""));
            String strToSign = UniClient.queryStringify(query);
            query.put("signature", UniClient.getSignature(strToSign, this.accessKeySecret));
        }
        return query;
    }

    public UniResponse request(String action, Map<String, Object> data) throws SmsBlendException {
        UniResponse smsResponse;
        String url;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", USER_AGENT);
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("Accept", "application/json");
        if (this.isSimple) {
            url = this.endpoint + "?action=" + action + "&accessKeyId=" + this.accessKeyId;
        } else {
            HashMap<String, Object> d = new HashMap<String, Object>();
            Map<String, Object> signed = this.sign(d);
            url = this.endpoint + "?action=" + action + "&accessKeyId=" + this.accessKeyId + "&algorithm=" + signed.get("algorithm") + "&timestamp=" + signed.get("timestamp") + "&nonce=" + signed.get("nonce") + "&signature=" + signed.get("signature");
        }
        try {
            smsResponse = new UniResponse(this.http.postJson(url, headers, data));
        }
        catch (SmsBlendException e) {
            smsResponse = new UniResponse();
            smsResponse.message = "Error";
        }
        if ("Success".equals(smsResponse.message) || this.retry == this.maxRetries) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(action, data);
    }

    private UniResponse requestRetry(String action, Map<String, Object> data) {
        this.http.safeSleep(this.retryInterval);
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.request(action, data);
    }

    public static class Builder {
        private String accessKeyId;
        private String accessKeySecret;
        private String endpoint;
        private String signingAlgorithm;
        private int retryInterval;
        private int maxRetries;
        private boolean isSimple;

        public Builder isSimple(boolean isSimple) {
            this.isSimple = isSimple;
            return this;
        }

        public Builder(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public Builder(String accessKeyId, String accessKeySecret) {
            this.accessKeyId = accessKeyId;
            this.accessKeySecret = accessKeySecret;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public Builder setRetryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public UniClient build() {
            return new UniClient(this);
        }
    }
}

