/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.cloopen.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsHttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloopenHelper {
    private static final Logger log = LoggerFactory.getLogger(CloopenHelper.class);
    private final CloopenConfig config;
    private final SmsHttpUtils http;
    private int retry = 0;

    public CloopenHelper(CloopenConfig config, SmsHttpUtils http) {
        this.config = config;
        this.http = http;
    }

    public SmsResponse smsResponse(Map<String, Object> paramMap) {
        String timestamp = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String url = String.format("%s/Accounts/%s/SMS/TemplateSMS?sig=%s", this.config.getBaseUrl(), this.config.getAccessKeyId(), this.generateSign(this.config.getAccessKeyId(), this.config.getAccessKeySecret(), timestamp));
        HashMap headers = MapUtil.newHashMap((int)3, (boolean)true);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("Authorization", this.generateAuthorization(this.config.getAccessKeyId(), timestamp));
        SmsResponse smsResponse = null;
        try {
            smsResponse = this.getResponse(this.http.postJson(url, (Map)headers, paramMap));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == this.config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(paramMap);
    }

    private SmsResponse requestRetry(Map<String, Object> paramMap) {
        this.http.safeSleep(this.config.getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.smsResponse(paramMap);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("000000".equals(resJson.getStr((Object)"statusCode")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.config.getConfigId());
        return smsResponse;
    }

    private String generateSign(String accessKeyId, String accessKeySecret, String timestamp) {
        return SecureUtil.md5((String)(accessKeyId + accessKeySecret + timestamp)).toUpperCase();
    }

    private String generateAuthorization(String accessKeyId, String timestamp) {
        return Base64.encode((CharSequence)(accessKeyId + ":" + timestamp));
    }
}

