/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.netease.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.netease.config.NeteaseConfig;
import org.dromara.sms4j.netease.utils.NeteaseUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeteaseSmsImpl
extends AbstractSmsBlend<NeteaseConfig> {
    private static final Logger log = LoggerFactory.getLogger(NeteaseSmsImpl.class);
    private int retry = 0;

    public NeteaseSmsImpl(NeteaseConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public NeteaseSmsImpl(NeteaseConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "netease";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        Optional.ofNullable(phone).orElseThrow(() -> new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Optional.ofNullable(((NeteaseConfig)this.getConfig()).getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        return this.getSmsResponse(((NeteaseConfig)this.getConfig()).getTemplateUrl(), Collections.singletonList(phone), message, ((NeteaseConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((NeteaseConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        Optional.ofNullable(phone).orElseThrow(() -> new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Optional.ofNullable(((NeteaseConfig)this.getConfig()).getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        String messageStr = messages.get("params");
        return this.getSmsResponse(((NeteaseConfig)this.getConfig()).getTemplateUrl(), Collections.singletonList(phone), messageStr, templateId);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        if (CollUtil.isEmpty(phones)) {
            throw new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (phones.size() > 100) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e100");
        }
        Optional.ofNullable(((NeteaseConfig)this.getConfig()).getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        return this.getSmsResponse(((NeteaseConfig)this.getConfig()).getTemplateUrl(), phones, ((NeteaseConfig)this.getConfig()).getTemplateId(), message);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        if (phones.size() > 100) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e100");
        }
        Optional.ofNullable(((NeteaseConfig)this.getConfig()).getTemplateId()).orElseThrow(() -> new SmsBlendException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a"));
        String messageStr = messages.get("message");
        return this.getSmsResponse(((NeteaseConfig)this.getConfig()).getTemplateUrl(), phones, messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String requestUrl, List<String> phones, String message, String templateId) {
        SmsResponse smsResponse;
        String nonce = IdUtil.fastSimpleUUID();
        String curTime = String.valueOf(DateUtil.currentSeconds());
        String checkSum = NeteaseUtils.getCheckSum(((NeteaseConfig)this.getConfig()).getAccessKeySecret(), nonce, curTime);
        HashMap body = MapUtil.newHashMap((int)4, (boolean)true);
        body.put("templateid", templateId);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(phones);
        body.put("mobiles", jsonArray.toString());
        if (!JSONUtil.isTypeJSONArray((String)message)) {
            jsonArray = new JSONArray();
            jsonArray.add((Object)message);
            body.put("params", jsonArray.toString());
        } else {
            body.put("params", message);
        }
        body.put("needUp", ((NeteaseConfig)this.getConfig()).getNeedUp());
        HashMap headers = MapUtil.newHashMap((int)5, (boolean)true);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("AppKey", ((NeteaseConfig)this.getConfig()).getAccessKeyId());
        headers.put("Nonce", nonce);
        headers.put("CurTime", curTime);
        headers.put("CheckSum", checkSum);
        try {
            smsResponse = this.getResponse(this.http.postFrom(requestUrl, (Map)headers, (Map)body));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((NeteaseConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(requestUrl, phones, message, templateId);
    }

    private SmsResponse requestRetry(String requestUrl, List<String> phones, String message, String templateId) {
        this.http.safeSleep(((NeteaseConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(requestUrl, phones, message, templateId);
    }

    private SmsResponse getResponse(JSONObject jsonObject) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess(jsonObject.getInt((Object)"code") <= 200);
        smsResponse.setData((Object)jsonObject);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

