/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.emay.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.crypto.SecureUtil;
import java.net.URLEncoder;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmayBuilder {
    private static final Logger log = LoggerFactory.getLogger(EmayBuilder.class);

    public static Map<String, Object> buildRequestBody(String appId, String secretKey, String phone, String message) throws SmsBlendException {
        return EmayBuilder.getParamsMap(appId, secretKey, phone, message);
    }

    public static Map<String, Object> buildRequestBody(String appId, String secretKey, String phone, String message, String customSmsId) throws SmsBlendException {
        Map<String, Object> params = EmayBuilder.getParamsMap(appId, secretKey, phone, message);
        params.put("customSmsId", customSmsId);
        return params;
    }

    private static Map<String, Object> getParamsMap(String appId, String secretKey, String phone, String message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String timestamp = DateUtil.format((Date)new Date(), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String sign = SecureUtil.md5((String)(appId + secretKey + timestamp));
        params.put("appId", appId);
        params.put("timestamp", timestamp);
        params.put("sign", sign);
        params.put("mobiles", phone);
        try {
            params.put("content", URLEncoder.encode(message, "utf-8"));
        }
        catch (Exception e) {
            log.error("EmaySmsImpl urlEncode content error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        return params;
    }

    public static String listToString(List<String> list) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("[\"");
        for (String s : list) {
            stringBuffer.append(s);
            stringBuffer.append("\"");
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

