/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.huawei.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiBuilder {
    private static final Logger log = LoggerFactory.getLogger(HuaweiBuilder.class);

    private HuaweiBuilder() {
    }

    public static String buildWsseHeader(String appKey, String appSecret) {
        if (null == appKey || null == appSecret || appKey.isEmpty() || appSecret.isEmpty()) {
            log.error("buildWsseHeader(): appKey or appSecret is null.");
            throw new SmsBlendException("buildWsseHeader(): appKey or appSecret is null.");
        }
        String time = HuaweiBuilder.dateFormat(new Date());
        String nonce = UUID.fastUUID().toString(true);
        byte[] passwordDigest = DigestUtil.sha256((String)(nonce + time + appSecret));
        String passwordDigestBase64Str = Base64.encode((byte[])passwordDigest);
        return String.format("UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"", appKey, passwordDigestBase64Str, nonce, time);
    }

    static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static String buildRequestBody(String sender, String receiver, String templateId, String templateParas, String statusCallBack, String signature) {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{sender, receiver, templateId})) {
            log.error("buildRequestBody(): sender, receiver or templateId is null.");
            throw new SmsBlendException("buildRequestBody(): sender, receiver or templateId is null.");
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("from", sender);
        map.put("to", receiver);
        map.put("templateId", templateId);
        if (null != templateParas && !templateParas.isEmpty()) {
            map.put("templateParas", templateParas);
        }
        if (null != statusCallBack && !statusCallBack.isEmpty()) {
            map.put("statusCallback", statusCallBack);
        }
        if (null != signature && !signature.isEmpty()) {
            map.put("signature", signature);
        }
        StringBuilder sb = new StringBuilder();
        map.keySet().forEach(s -> sb.append((String)s).append("=").append(URLEncodeUtil.encode((String)((String)map.get(s)))).append("&"));
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String listToString(List<String> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("[\"");
        for (String s : list) {
            stringBuffer.append(s);
            stringBuffer.append("\"");
            stringBuffer.append(",");
            stringBuffer.append("\"");
        }
        stringBuffer.delete(stringBuffer.length() - 3, stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String dateFormat(Date date) {
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    }
}

